@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.schemas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Discoverer].
 */
@PulumiTagMarker
public class DiscovererResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiscovererArgs = DiscovererArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiscovererArgsBuilder.() -> Unit) {
        val builder = DiscovererArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Discoverer {
        val builtJavaResource = com.pulumi.aws.schemas.Discoverer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Discoverer(builtJavaResource)
    }
}

/**
 * Provides an EventBridge Schema Discoverer resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.schemas.Discoverer;
 * import com.pulumi.aws.schemas.DiscovererArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var messenger = new EventBus("messenger");
 *         var test = new Discoverer("test", DiscovererArgs.builder()
 *             .sourceArn(messenger.arn())
 *             .description("Auto discover event schemas")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge discoverers using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:schemas/discoverer:Discoverer test 123
 * ```
 *
 */
public class Discoverer internal constructor(
    override val javaResource: com.pulumi.aws.schemas.Discoverer,
) : KotlinCustomResource(javaResource, DiscovererMapper) {
    /**
     * The Amazon Resource Name (ARN) of the discoverer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the discoverer. Maximum of 256 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the event bus to discover event schemas on.
     */
    public val sourceArn: Output<String>
        get() = javaResource.sourceArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DiscovererMapper : ResourceMapper<Discoverer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.schemas.Discoverer::class == javaResource::class

    override fun map(javaResource: Resource): Discoverer = Discoverer(
        javaResource as
            com.pulumi.aws.schemas.Discoverer,
    )
}

/**
 * @see [Discoverer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Discoverer].
 */
public suspend fun discoverer(name: String, block: suspend DiscovererResourceBuilder.() -> Unit):
    Discoverer {
    val builder = DiscovererResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Discoverer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun discoverer(name: String): Discoverer {
    val builder = DiscovererResourceBuilder()
    builder.name(name)
    return builder.build()
}
