@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.schemas.kotlin

import com.pulumi.aws.schemas.DiscovererArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge Schema Discoverer resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.EventBus;
 * import com.pulumi.aws.schemas.Discoverer;
 * import com.pulumi.aws.schemas.DiscovererArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var messenger = new EventBus("messenger");
 *         var test = new Discoverer("test", DiscovererArgs.builder()
 *             .sourceArn(messenger.arn())
 *             .description("Auto discover event schemas")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge discoverers using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:schemas/discoverer:Discoverer test 123
 * ```
 * @property description The description of the discoverer. Maximum of 256 characters.
 * @property sourceArn The ARN of the event bus to discover event schemas on.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DiscovererArgs(
    public val description: Output<String>? = null,
    public val sourceArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.schemas.DiscovererArgs> {
    override fun toJava(): com.pulumi.aws.schemas.DiscovererArgs =
        com.pulumi.aws.schemas.DiscovererArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .sourceArn(sourceArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DiscovererArgs].
 */
@PulumiTagMarker
public class DiscovererArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var sourceArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the discoverer. Maximum of 256 characters.
     */
    @JvmName("aumedysinlldqvyt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ARN of the event bus to discover event schemas on.
     */
    @JvmName("oktbnnlqvoljyjtq")
    public suspend fun sourceArn(`value`: Output<String>) {
        this.sourceArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("onrshryipgfxkwjv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the discoverer. Maximum of 256 characters.
     */
    @JvmName("viugjyfxoujuvday")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ARN of the event bus to discover event schemas on.
     */
    @JvmName("ipkenjrhmssloefm")
    public suspend fun sourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gpmejcyipsypkwgj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qtxprdfscehnjlxb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DiscovererArgs = DiscovererArgs(
        description = description,
        sourceArn = sourceArn,
        tags = tags,
    )
}
