@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.schemas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Registry].
 */
@PulumiTagMarker
public class RegistryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryArgs = RegistryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryArgsBuilder.() -> Unit) {
        val builder = RegistryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Registry {
        val builtJavaResource = com.pulumi.aws.schemas.Registry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Registry(builtJavaResource)
    }
}

/**
 * Provides an EventBridge Custom Schema Registry resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.schemas.Registry;
 * import com.pulumi.aws.schemas.RegistryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Registry("test", RegistryArgs.builder()
 *             .description("A custom schema registry")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge schema registries using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:schemas/registry:Registry test my_own_registry
 * ```
 *
 */
public class Registry internal constructor(
    override val javaResource: com.pulumi.aws.schemas.Registry,
) : KotlinCustomResource(javaResource, RegistryMapper) {
    /**
     * The Amazon Resource Name (ARN) of the discoverer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the discoverer. Maximum of 256 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the custom event schema registry. Maximum of 64 characters consisting of lower case letters, upper case letters, 0-9, ., -, _.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RegistryMapper : ResourceMapper<Registry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.schemas.Registry::class == javaResource::class

    override fun map(javaResource: Resource): Registry = Registry(
        javaResource as
            com.pulumi.aws.schemas.Registry,
    )
}

/**
 * @see [Registry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Registry].
 */
public suspend fun registry(name: String, block: suspend RegistryResourceBuilder.() -> Unit):
    Registry {
    val builder = RegistryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Registry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registry(name: String): Registry {
    val builder = RegistryResourceBuilder()
    builder.name(name)
    return builder.build()
}
