@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.schemas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RegistryPolicy].
 */
@PulumiTagMarker
public class RegistryPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryPolicyArgs = RegistryPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryPolicyArgsBuilder.() -> Unit) {
        val builder = RegistryPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RegistryPolicy {
        val builtJavaResource = com.pulumi.aws.schemas.RegistryPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegistryPolicy(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS EventBridge Schemas Registry Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.schemas.RegistryPolicy;
 * import com.pulumi.aws.schemas.RegistryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("example")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("109876543210")
 *                     .build())
 *                 .actions("schemas:*")
 *                 .resources(
 *                     "arn:aws:schemas:us-east-1:012345678901:registry/example",
 *                     "arn:aws:schemas:us-east-1:012345678901:schema/example*")
 *                 .build())
 *             .build());
 *         var exampleRegistryPolicy = new RegistryPolicy("exampleRegistryPolicy", RegistryPolicyArgs.builder()
 *             .registryName("example")
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge Schema Registry Policy using the `registry_name`. For example:
 * ```sh
 *  $ pulumi import aws:schemas/registryPolicy:RegistryPolicy example example
 * ```
 *
 */
public class RegistryPolicy internal constructor(
    override val javaResource: com.pulumi.aws.schemas.RegistryPolicy,
) : KotlinCustomResource(javaResource, RegistryPolicyMapper) {
    /**
     * Resource Policy for EventBridge Schema Registry
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * Name of EventBridge Schema Registry
     */
    public val registryName: Output<String>
        get() = javaResource.registryName().applyValue({ args0 -> args0 })
}

public object RegistryPolicyMapper : ResourceMapper<RegistryPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.schemas.RegistryPolicy::class == javaResource::class

    override fun map(javaResource: Resource): RegistryPolicy = RegistryPolicy(
        javaResource as
            com.pulumi.aws.schemas.RegistryPolicy,
    )
}

/**
 * @see [RegistryPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryPolicy].
 */
public suspend fun registryPolicy(
    name: String,
    block: suspend RegistryPolicyResourceBuilder.() -> Unit,
): RegistryPolicy {
    val builder = RegistryPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryPolicy(name: String): RegistryPolicy {
    val builder = RegistryPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
