@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.schemas.kotlin

import com.pulumi.aws.schemas.RegistryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS EventBridge Schemas Registry Policy.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.schemas.RegistryPolicy;
 * import com.pulumi.aws.schemas.RegistryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("example")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("109876543210")
 *                     .build())
 *                 .actions("schemas:*")
 *                 .resources(
 *                     "arn:aws:schemas:us-east-1:012345678901:registry/example",
 *                     "arn:aws:schemas:us-east-1:012345678901:schema/example*")
 *                 .build())
 *             .build());
 *         var exampleRegistryPolicy = new RegistryPolicy("exampleRegistryPolicy", RegistryPolicyArgs.builder()
 *             .registryName("example")
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge Schema Registry Policy using the `registry_name`. For example:
 * ```sh
 *  $ pulumi import aws:schemas/registryPolicy:RegistryPolicy example example
 * ```
 * @property policy Resource Policy for EventBridge Schema Registry
 * @property registryName Name of EventBridge Schema Registry
 */
public data class RegistryPolicyArgs(
    public val policy: Output<String>? = null,
    public val registryName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.schemas.RegistryPolicyArgs> {
    override fun toJava(): com.pulumi.aws.schemas.RegistryPolicyArgs =
        com.pulumi.aws.schemas.RegistryPolicyArgs.builder()
            .policy(policy?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryPolicyArgs].
 */
@PulumiTagMarker
public class RegistryPolicyArgsBuilder internal constructor() {
    private var policy: Output<String>? = null

    private var registryName: Output<String>? = null

    /**
     * @param value Resource Policy for EventBridge Schema Registry
     */
    @JvmName("wwquhckjypfdggxq")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Name of EventBridge Schema Registry
     */
    @JvmName("krrebbbhmxpcroxq")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value Resource Policy for EventBridge Schema Registry
     */
    @JvmName("chsmhoqwwejdsnsm")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Name of EventBridge Schema Registry
     */
    @JvmName("tbdlnldwunviurin")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    internal fun build(): RegistryPolicyArgs = RegistryPolicyArgs(
        policy = policy,
        registryName = registryName,
    )
}
