@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.schemas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Schema].
 */
@PulumiTagMarker
public class SchemaResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SchemaArgs = SchemaArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SchemaArgsBuilder.() -> Unit) {
        val builder = SchemaArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Schema {
        val builtJavaResource = com.pulumi.aws.schemas.Schema(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schema(builtJavaResource)
    }
}

/**
 * Provides an EventBridge Schema resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.schemas.Registry;
 * import com.pulumi.aws.schemas.Schema;
 * import com.pulumi.aws.schemas.SchemaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRegistry = new Registry("testRegistry");
 *         var testSchema = new Schema("testSchema", SchemaArgs.builder()
 *             .registryName(testRegistry.name())
 *             .type("OpenApi3")
 *             .description("The schema definition for my event")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.0"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("version", "1.0.0"),
 *                         jsonProperty("title", "Event")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                     )),
 *                     jsonProperty("components", jsonObject(
 *                         jsonProperty("schemas", jsonObject(
 *                             jsonProperty("Event", jsonObject(
 *                                 jsonProperty("type", "object"),
 *                                 jsonProperty("properties", jsonObject(
 *                                     jsonProperty("name", jsonObject(
 *                                         jsonProperty("type", "string")
 *                                     ))
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge schema using the `name` and `registry_name`. For example:
 * ```sh
 *  $ pulumi import aws:schemas/schema:Schema test name/registry
 * ```
 *
 */
public class Schema internal constructor(
    override val javaResource: com.pulumi.aws.schemas.Schema,
) : KotlinCustomResource(javaResource, SchemaMapper) {
    /**
     * The Amazon Resource Name (ARN) of the discoverer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The schema specification. Must be a valid Open API 3.0 spec.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * The description of the schema. Maximum of 256 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The last modified date of the schema.
     */
    public val lastModified: Output<String>
        get() = javaResource.lastModified().applyValue({ args0 -> args0 })

    /**
     * The name of the schema. Maximum of 385 characters consisting of lower case letters, upper case letters, ., -, _, @.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the registry in which this schema belongs.
     */
    public val registryName: Output<String>
        get() = javaResource.registryName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of the schema. Valid values: `OpenApi3` or `JSONSchemaDraft4`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The version of the schema.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The created date of the version of the schema.
     */
    public val versionCreatedDate: Output<String>
        get() = javaResource.versionCreatedDate().applyValue({ args0 -> args0 })
}

public object SchemaMapper : ResourceMapper<Schema> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.schemas.Schema::class == javaResource::class

    override fun map(javaResource: Resource): Schema = Schema(
        javaResource as
            com.pulumi.aws.schemas.Schema,
    )
}

/**
 * @see [Schema].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schema].
 */
public suspend fun schema(name: String, block: suspend SchemaResourceBuilder.() -> Unit): Schema {
    val builder = SchemaResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schema].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schema(name: String): Schema {
    val builder = SchemaResourceBuilder()
    builder.name(name)
    return builder.build()
}
