@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.schemas.kotlin

import com.pulumi.aws.schemas.SchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge Schema resource.
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.schemas.Registry;
 * import com.pulumi.aws.schemas.Schema;
 * import com.pulumi.aws.schemas.SchemaArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testRegistry = new Registry("testRegistry");
 *         var testSchema = new Schema("testSchema", SchemaArgs.builder()
 *             .registryName(testRegistry.name())
 *             .type("OpenApi3")
 *             .description("The schema definition for my event")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("openapi", "3.0.0"),
 *                     jsonProperty("info", jsonObject(
 *                         jsonProperty("version", "1.0.0"),
 *                         jsonProperty("title", "Event")
 *                     )),
 *                     jsonProperty("paths", jsonObject(
 *                     )),
 *                     jsonProperty("components", jsonObject(
 *                         jsonProperty("schemas", jsonObject(
 *                             jsonProperty("Event", jsonObject(
 *                                 jsonProperty("type", "object"),
 *                                 jsonProperty("properties", jsonObject(
 *                                     jsonProperty("name", jsonObject(
 *                                         jsonProperty("type", "string")
 *                                     ))
 *                                 ))
 *                             ))
 *                         ))
 *                     ))
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EventBridge schema using the `name` and `registry_name`. For example:
 * ```sh
 *  $ pulumi import aws:schemas/schema:Schema test name/registry
 * ```
 * @property content The schema specification. Must be a valid Open API 3.0 spec.
 * @property description The description of the schema. Maximum of 256 characters.
 * @property name The name of the schema. Maximum of 385 characters consisting of lower case letters, upper case letters, ., -, _, @.
 * @property registryName The name of the registry in which this schema belongs.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of the schema. Valid values: `OpenApi3` or `JSONSchemaDraft4`.
 */
public data class SchemaArgs(
    public val content: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.schemas.SchemaArgs> {
    override fun toJava(): com.pulumi.aws.schemas.SchemaArgs =
        com.pulumi.aws.schemas.SchemaArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SchemaArgs].
 */
@PulumiTagMarker
public class SchemaArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var registryName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The schema specification. Must be a valid Open API 3.0 spec.
     */
    @JvmName("brhytnlfrcsktcka")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The description of the schema. Maximum of 256 characters.
     */
    @JvmName("mduvjswfsfpkckgq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the schema. Maximum of 385 characters consisting of lower case letters, upper case letters, ., -, _, @.
     */
    @JvmName("qraomwlappkvasxb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the registry in which this schema belongs.
     */
    @JvmName("myqucuxtlhkrytrt")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nijxwycohttvuodr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the schema. Valid values: `OpenApi3` or `JSONSchemaDraft4`.
     */
    @JvmName("ctxdxwutjbfkbjky")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The schema specification. Must be a valid Open API 3.0 spec.
     */
    @JvmName("kofcjgsmyaraeifi")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The description of the schema. Maximum of 256 characters.
     */
    @JvmName("mqarxxwqwsnmvswq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the schema. Maximum of 385 characters consisting of lower case letters, upper case letters, ., -, _, @.
     */
    @JvmName("dtytefokpxwwvlyi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the registry in which this schema belongs.
     */
    @JvmName("qpjgvxgfsewrvymp")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wmbbmkrgpfucydhm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cvtuyfcabxnqdiad")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of the schema. Valid values: `OpenApi3` or `JSONSchemaDraft4`.
     */
    @JvmName("ncxkogfkxpdwkhyq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SchemaArgs = SchemaArgs(
        content = content,
        description = description,
        name = name,
        registryName = registryName,
        tags = tags,
        type = type,
    )
}
