@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.aws.secretsmanager.SecretArgs.builder
import com.pulumi.aws.secretsmanager.kotlin.inputs.SecretReplicaArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.SecretReplicaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Secrets Manager secret metadata. To manage secret rotation, see the `aws.secretsmanager.SecretRotation` resource. To manage a secret value, see the `aws.secretsmanager.SecretVersion` resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Secret("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_secretsmanager_secret` using the secret Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:secretsmanager/secret:Secret example arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456
 * ```
 * @property description Description of the secret.
 * @property forceOverwriteReplicaSecret Accepts boolean value to specify whether to overwrite a secret with the same name in the destination Region.
 * @property kmsKeyId ARN or Id of the AWS KMS key to be used to encrypt the secret values in the versions stored in this secret. If you need to reference a CMK in a different account, you can use only the key ARN. If you don't specify this value, then Secrets Manager defaults to using the AWS account's default KMS key (the one named `aws/secretsmanager`). If the default KMS key with that name doesn't yet exist, then AWS Secrets Manager creates it for you automatically the first time.
 * @property name Friendly name of the new secret. The secret name can consist of uppercase letters, lowercase letters, digits, and any of the following characters: `/_+=.@-` Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property policy Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.secretsmanager.SecretPolicy`. To delete the `policy`, set it to `"{}"` (an empty JSON document).
 * @property recoveryWindowInDays Number of days that AWS Secrets Manager waits before it can delete the secret. This value can be `0` to force deletion without recovery or range from `7` to `30` days. The default value is `30`.
 * @property replicas Configuration block to support secret replication. See details below.
 * @property tags Key-value map of user-defined tags that are attached to the secret. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SecretArgs(
    public val description: Output<String>? = null,
    public val forceOverwriteReplicaSecret: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val recoveryWindowInDays: Output<Int>? = null,
    public val replicas: Output<List<SecretReplicaArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.SecretArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.SecretArgs =
        com.pulumi.aws.secretsmanager.SecretArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .forceOverwriteReplicaSecret(forceOverwriteReplicaSecret?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .recoveryWindowInDays(recoveryWindowInDays?.applyValue({ args0 -> args0 }))
            .replicas(
                replicas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SecretArgs].
 */
@PulumiTagMarker
public class SecretArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var forceOverwriteReplicaSecret: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var policy: Output<String>? = null

    private var recoveryWindowInDays: Output<Int>? = null

    private var replicas: Output<List<SecretReplicaArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the secret.
     */
    @JvmName("xriiodbskebcaswi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Accepts boolean value to specify whether to overwrite a secret with the same name in the destination Region.
     */
    @JvmName("fwskhvxgptqpiqfm")
    public suspend fun forceOverwriteReplicaSecret(`value`: Output<Boolean>) {
        this.forceOverwriteReplicaSecret = value
    }

    /**
     * @param value ARN or Id of the AWS KMS key to be used to encrypt the secret values in the versions stored in this secret. If you need to reference a CMK in a different account, you can use only the key ARN. If you don't specify this value, then Secrets Manager defaults to using the AWS account's default KMS key (the one named `aws/secretsmanager`). If the default KMS key with that name doesn't yet exist, then AWS Secrets Manager creates it for you automatically the first time.
     */
    @JvmName("dgvphjvllbpnuqpx")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Friendly name of the new secret. The secret name can consist of uppercase letters, lowercase letters, digits, and any of the following characters: `/_+=.@-` Conflicts with `name_prefix`.
     */
    @JvmName("sjgygppwtoigebia")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("wxmtkdtloflnmtvx")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.secretsmanager.SecretPolicy`. To delete the `policy`, set it to `"{}"` (an empty JSON document).
     */
    @JvmName("nhkktgyjrpnfqbte")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Number of days that AWS Secrets Manager waits before it can delete the secret. This value can be `0` to force deletion without recovery or range from `7` to `30` days. The default value is `30`.
     */
    @JvmName("wfqrwtsmuigaubrm")
    public suspend fun recoveryWindowInDays(`value`: Output<Int>) {
        this.recoveryWindowInDays = value
    }

    /**
     * @param value Configuration block to support secret replication. See details below.
     */
    @JvmName("lokeseqxshduykfv")
    public suspend fun replicas(`value`: Output<List<SecretReplicaArgs>>) {
        this.replicas = value
    }

    @JvmName("rcdaqdpxdyvvflcs")
    public suspend fun replicas(vararg values: Output<SecretReplicaArgs>) {
        this.replicas = Output.all(values.asList())
    }

    /**
     * @param values Configuration block to support secret replication. See details below.
     */
    @JvmName("rydfchnplincnnac")
    public suspend fun replicas(values: List<Output<SecretReplicaArgs>>) {
        this.replicas = Output.all(values)
    }

    /**
     * @param value Key-value map of user-defined tags that are attached to the secret. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bkbmvxvdbuidrfvi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the secret.
     */
    @JvmName("avrkopiwbiljpvbr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Accepts boolean value to specify whether to overwrite a secret with the same name in the destination Region.
     */
    @JvmName("gfnsxsnntxqrgeeq")
    public suspend fun forceOverwriteReplicaSecret(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceOverwriteReplicaSecret = mapped
    }

    /**
     * @param value ARN or Id of the AWS KMS key to be used to encrypt the secret values in the versions stored in this secret. If you need to reference a CMK in a different account, you can use only the key ARN. If you don't specify this value, then Secrets Manager defaults to using the AWS account's default KMS key (the one named `aws/secretsmanager`). If the default KMS key with that name doesn't yet exist, then AWS Secrets Manager creates it for you automatically the first time.
     */
    @JvmName("tdwxnopviuymjbjf")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Friendly name of the new secret. The secret name can consist of uppercase letters, lowercase letters, digits, and any of the following characters: `/_+=.@-` Conflicts with `name_prefix`.
     */
    @JvmName("elhyxxqinjltjufd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("usovbqoieiovecnn")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Removing `policy` from your configuration or setting `policy` to null or an empty string (i.e., `policy = ""`) _will not_ delete the policy since it could have been set by `aws.secretsmanager.SecretPolicy`. To delete the `policy`, set it to `"{}"` (an empty JSON document).
     */
    @JvmName("nnsggkjokwfnoaay")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Number of days that AWS Secrets Manager waits before it can delete the secret. This value can be `0` to force deletion without recovery or range from `7` to `30` days. The default value is `30`.
     */
    @JvmName("yvmuasymskaqdley")
    public suspend fun recoveryWindowInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryWindowInDays = mapped
    }

    /**
     * @param value Configuration block to support secret replication. See details below.
     */
    @JvmName("cqpdtkntdnbbwoge")
    public suspend fun replicas(`value`: List<SecretReplicaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param argument Configuration block to support secret replication. See details below.
     */
    @JvmName("yjqvgkwgkjvlfiwv")
    public suspend fun replicas(argument: List<suspend SecretReplicaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SecretReplicaArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param argument Configuration block to support secret replication. See details below.
     */
    @JvmName("imayiggvklacvpsw")
    public suspend fun replicas(vararg argument: suspend SecretReplicaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SecretReplicaArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param argument Configuration block to support secret replication. See details below.
     */
    @JvmName("jbnfxjufgeectqyt")
    public suspend fun replicas(argument: suspend SecretReplicaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SecretReplicaArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.replicas = mapped
    }

    /**
     * @param values Configuration block to support secret replication. See details below.
     */
    @JvmName("lfnnpegjjgtsjgbh")
    public suspend fun replicas(vararg values: SecretReplicaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param value Key-value map of user-defined tags that are attached to the secret. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kayhuyijympvnamr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of user-defined tags that are attached to the secret. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("imvkeusuhbexsrnt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SecretArgs = SecretArgs(
        description = description,
        forceOverwriteReplicaSecret = forceOverwriteReplicaSecret,
        kmsKeyId = kmsKeyId,
        name = name,
        namePrefix = namePrefix,
        policy = policy,
        recoveryWindowInDays = recoveryWindowInDays,
        replicas = replicas,
        tags = tags,
    )
}
