@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecretPolicy].
 */
@PulumiTagMarker
public class SecretPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretPolicyArgs = SecretPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretPolicyArgsBuilder.() -> Unit) {
        val builder = SecretPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecretPolicy {
        val builtJavaResource = com.pulumi.aws.secretsmanager.SecretPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecretPolicy(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Secrets Manager secret policy.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.secretsmanager.SecretPolicy;
 * import com.pulumi.aws.secretsmanager.SecretPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSecret = new Secret("exampleSecret");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("EnableAnotherAWSAccountToReadTheSecret")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("arn:aws:iam::123456789012:root")
 *                     .build())
 *                 .actions("secretsmanager:GetSecretValue")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleSecretPolicy = new SecretPolicy("exampleSecretPolicy", SecretPolicyArgs.builder()
 *             .secretArn(exampleSecret.arn())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_secretsmanager_secret_policy` using the secret Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:secretsmanager/secretPolicy:SecretPolicy example arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456
 * ```
 *
 */
public class SecretPolicy internal constructor(
    override val javaResource: com.pulumi.aws.secretsmanager.SecretPolicy,
) : KotlinCustomResource(javaResource, SecretPolicyMapper) {
    /**
     * Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
     */
    public val blockPublicPolicy: Output<Boolean>?
        get() = javaResource.blockPublicPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `aws.secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * Secret ARN.
     * The following arguments are optional:
     */
    public val secretArn: Output<String>
        get() = javaResource.secretArn().applyValue({ args0 -> args0 })
}

public object SecretPolicyMapper : ResourceMapper<SecretPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.secretsmanager.SecretPolicy::class == javaResource::class

    override fun map(javaResource: Resource): SecretPolicy = SecretPolicy(
        javaResource as
            com.pulumi.aws.secretsmanager.SecretPolicy,
    )
}

/**
 * @see [SecretPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecretPolicy].
 */
public suspend fun secretPolicy(
    name: String,
    block: suspend SecretPolicyResourceBuilder.() -> Unit,
): SecretPolicy {
    val builder = SecretPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecretPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secretPolicy(name: String): SecretPolicy {
    val builder = SecretPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
