@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.aws.secretsmanager.SecretPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Secrets Manager secret policy.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.Secret;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.secretsmanager.SecretPolicy;
 * import com.pulumi.aws.secretsmanager.SecretPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSecret = new Secret("exampleSecret");
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("EnableAnotherAWSAccountToReadTheSecret")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("arn:aws:iam::123456789012:root")
 *                     .build())
 *                 .actions("secretsmanager:GetSecretValue")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleSecretPolicy = new SecretPolicy("exampleSecretPolicy", SecretPolicyArgs.builder()
 *             .secretArn(exampleSecret.arn())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_secretsmanager_secret_policy` using the secret Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:secretsmanager/secretPolicy:SecretPolicy example arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456
 * ```
 * @property blockPublicPolicy Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
 * @property policy Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `aws.secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
 * @property secretArn Secret ARN.
 * The following arguments are optional:
 */
public data class SecretPolicyArgs(
    public val blockPublicPolicy: Output<Boolean>? = null,
    public val policy: Output<String>? = null,
    public val secretArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.SecretPolicyArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.SecretPolicyArgs =
        com.pulumi.aws.secretsmanager.SecretPolicyArgs.builder()
            .blockPublicPolicy(blockPublicPolicy?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .secretArn(secretArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretPolicyArgs].
 */
@PulumiTagMarker
public class SecretPolicyArgsBuilder internal constructor() {
    private var blockPublicPolicy: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var secretArn: Output<String>? = null

    /**
     * @param value Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
     */
    @JvmName("hlmwfadgsvfoxkno")
    public suspend fun blockPublicPolicy(`value`: Output<Boolean>) {
        this.blockPublicPolicy = value
    }

    /**
     * @param value Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `aws.secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
     */
    @JvmName("qdvwfvmmuvcwnbxm")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Secret ARN.
     * The following arguments are optional:
     */
    @JvmName("fgffaogyivucjvht")
    public suspend fun secretArn(`value`: Output<String>) {
        this.secretArn = value
    }

    /**
     * @param value Makes an optional API call to Zelkova to validate the Resource Policy to prevent broad access to your secret.
     */
    @JvmName("cfetrhejasklkyrn")
    public suspend fun blockPublicPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockPublicPolicy = mapped
    }

    /**
     * @param value Valid JSON document representing a [resource policy](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_resource-based-policies.html). Unlike `aws.secretsmanager.Secret`, where `policy` can be set to `"{}"` to delete the policy, `"{}"` is not a valid policy since `policy` is required.
     */
    @JvmName("obpcrmnijxryceuw")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Secret ARN.
     * The following arguments are optional:
     */
    @JvmName("hgyetcyohfgjkwkf")
    public suspend fun secretArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretArn = mapped
    }

    internal fun build(): SecretPolicyArgs = SecretPolicyArgs(
        blockPublicPolicy = blockPublicPolicy,
        policy = policy,
        secretArn = secretArn,
    )
}
