@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.aws.secretsmanager.kotlin.outputs.SecretRotationRotationRules
import com.pulumi.aws.secretsmanager.kotlin.outputs.SecretRotationRotationRules.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecretRotation].
 */
@PulumiTagMarker
public class SecretRotationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretRotationArgs = SecretRotationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretRotationArgsBuilder.() -> Unit) {
        val builder = SecretRotationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecretRotation {
        val builtJavaResource = com.pulumi.aws.secretsmanager.SecretRotation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecretRotation(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Secrets Manager secret rotation. To manage a secret, see the `aws.secretsmanager.Secret` resource. To manage a secret value, see the `aws.secretsmanager.SecretVersion` resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.SecretRotation;
 * import com.pulumi.aws.secretsmanager.SecretRotationArgs;
 * import com.pulumi.aws.secretsmanager.inputs.SecretRotationRotationRulesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecretRotation("example", SecretRotationArgs.builder()
 *             .secretId(aws_secretsmanager_secret.example().id())
 *             .rotationLambdaArn(aws_lambda_function.example().arn())
 *             .rotationRules(SecretRotationRotationRulesArgs.builder()
 *                 .automaticallyAfterDays(30)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_secretsmanager_secret_rotation` using the secret Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:secretsmanager/secretRotation:SecretRotation example arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456
 * ```
 *
 */
public class SecretRotation internal constructor(
    override val javaResource: com.pulumi.aws.secretsmanager.SecretRotation,
) : KotlinCustomResource(javaResource, SecretRotationMapper) {
    /**
     * Specifies whether automatic rotation is enabled for this secret.
     */
    public val rotationEnabled: Output<Boolean>
        get() = javaResource.rotationEnabled().applyValue({ args0 -> args0 })

    /**
     * Specifies the ARN of the Lambda function that can rotate the secret. Must be supplied if the secret is not managed by AWS.
     */
    public val rotationLambdaArn: Output<String>?
        get() = javaResource.rotationLambdaArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A structure that defines the rotation configuration for this secret. Defined below.
     */
    public val rotationRules: Output<SecretRotationRotationRules>
        get() = javaResource.rotationRules().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Specifies the secret to which you want to add a new version. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret. The secret must already exist.
     */
    public val secretId: Output<String>
        get() = javaResource.secretId().applyValue({ args0 -> args0 })
}

public object SecretRotationMapper : ResourceMapper<SecretRotation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.secretsmanager.SecretRotation::class == javaResource::class

    override fun map(javaResource: Resource): SecretRotation = SecretRotation(
        javaResource as
            com.pulumi.aws.secretsmanager.SecretRotation,
    )
}

/**
 * @see [SecretRotation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecretRotation].
 */
public suspend fun secretRotation(
    name: String,
    block: suspend SecretRotationResourceBuilder.() -> Unit,
): SecretRotation {
    val builder = SecretRotationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecretRotation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secretRotation(name: String): SecretRotation {
    val builder = SecretRotationResourceBuilder()
    builder.name(name)
    return builder.build()
}
