@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.aws.secretsmanager.SecretRotationArgs.builder
import com.pulumi.aws.secretsmanager.kotlin.inputs.SecretRotationRotationRulesArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.SecretRotationRotationRulesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Secrets Manager secret rotation. To manage a secret, see the `aws.secretsmanager.Secret` resource. To manage a secret value, see the `aws.secretsmanager.SecretVersion` resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.SecretRotation;
 * import com.pulumi.aws.secretsmanager.SecretRotationArgs;
 * import com.pulumi.aws.secretsmanager.inputs.SecretRotationRotationRulesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecretRotation("example", SecretRotationArgs.builder()
 *             .secretId(aws_secretsmanager_secret.example().id())
 *             .rotationLambdaArn(aws_lambda_function.example().arn())
 *             .rotationRules(SecretRotationRotationRulesArgs.builder()
 *                 .automaticallyAfterDays(30)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_secretsmanager_secret_rotation` using the secret Amazon Resource Name (ARN). For example:
 * ```sh
 *  $ pulumi import aws:secretsmanager/secretRotation:SecretRotation example arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456
 * ```
 * @property rotationLambdaArn Specifies the ARN of the Lambda function that can rotate the secret. Must be supplied if the secret is not managed by AWS.
 * @property rotationRules A structure that defines the rotation configuration for this secret. Defined below.
 * @property secretId Specifies the secret to which you want to add a new version. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret. The secret must already exist.
 */
public data class SecretRotationArgs(
    public val rotationLambdaArn: Output<String>? = null,
    public val rotationRules: Output<SecretRotationRotationRulesArgs>? = null,
    public val secretId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.SecretRotationArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.SecretRotationArgs =
        com.pulumi.aws.secretsmanager.SecretRotationArgs.builder()
            .rotationLambdaArn(rotationLambdaArn?.applyValue({ args0 -> args0 }))
            .rotationRules(rotationRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .secretId(secretId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretRotationArgs].
 */
@PulumiTagMarker
public class SecretRotationArgsBuilder internal constructor() {
    private var rotationLambdaArn: Output<String>? = null

    private var rotationRules: Output<SecretRotationRotationRulesArgs>? = null

    private var secretId: Output<String>? = null

    /**
     * @param value Specifies the ARN of the Lambda function that can rotate the secret. Must be supplied if the secret is not managed by AWS.
     */
    @JvmName("yrosjufnnsounxmf")
    public suspend fun rotationLambdaArn(`value`: Output<String>) {
        this.rotationLambdaArn = value
    }

    /**
     * @param value A structure that defines the rotation configuration for this secret. Defined below.
     */
    @JvmName("naoivenixwjcywpt")
    public suspend fun rotationRules(`value`: Output<SecretRotationRotationRulesArgs>) {
        this.rotationRules = value
    }

    /**
     * @param value Specifies the secret to which you want to add a new version. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret. The secret must already exist.
     */
    @JvmName("dtnmfkbncikuvnaf")
    public suspend fun secretId(`value`: Output<String>) {
        this.secretId = value
    }

    /**
     * @param value Specifies the ARN of the Lambda function that can rotate the secret. Must be supplied if the secret is not managed by AWS.
     */
    @JvmName("tgmjutofuwomkaos")
    public suspend fun rotationLambdaArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotationLambdaArn = mapped
    }

    /**
     * @param value A structure that defines the rotation configuration for this secret. Defined below.
     */
    @JvmName("wbqyigsjocvgashr")
    public suspend fun rotationRules(`value`: SecretRotationRotationRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotationRules = mapped
    }

    /**
     * @param argument A structure that defines the rotation configuration for this secret. Defined below.
     */
    @JvmName("goxihqblrqmxjcfd")
    public suspend
    fun rotationRules(argument: suspend SecretRotationRotationRulesArgsBuilder.() -> Unit) {
        val toBeMapped = SecretRotationRotationRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rotationRules = mapped
    }

    /**
     * @param value Specifies the secret to which you want to add a new version. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret. The secret must already exist.
     */
    @JvmName("mmyomjdqrhursvlr")
    public suspend fun secretId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretId = mapped
    }

    internal fun build(): SecretRotationArgs = SecretRotationArgs(
        rotationLambdaArn = rotationLambdaArn,
        rotationRules = rotationRules,
        secretId = secretId,
    )
}
