@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SecretVersion].
 */
@PulumiTagMarker
public class SecretVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretVersionArgs = SecretVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretVersionArgsBuilder.() -> Unit) {
        val builder = SecretVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecretVersion {
        val builtJavaResource = com.pulumi.aws.secretsmanager.SecretVersion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecretVersion(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Secrets Manager secret version including its secret value. To manage secret metadata, see the `aws.secretsmanager.Secret` resource.
 * > **NOTE:** If the `AWSCURRENT` staging label is present on this version during resource deletion, that label cannot be removed and will be skipped to prevent errors when fully deleting the secret. That label will leave this secret version active even after the resource is deleted from this provider unless the secret itself is deleted. Move the `AWSCURRENT` staging label before or after deleting this resource from this provider to fully trigger version deprecation if necessary.
 * ## Example Usage
 * ### Simple String Value
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.secretsmanager.SecretVersion;
 * import com.pulumi.aws.secretsmanager.SecretVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecretVersion("example", SecretVersionArgs.builder()
 *             .secretId(aws_secretsmanager_secret.example().id())
 *             .secretString("example-string-to-protect")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_secretsmanager_secret_version` using the secret ID and version ID. For example:
 * ```sh
 *  $ pulumi import aws:secretsmanager/secretVersion:SecretVersion example 'arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456|xxxxx-xxxxxxx-xxxxxxx-xxxxx'
 * ```
 *
 */
public class SecretVersion internal constructor(
    override val javaResource: com.pulumi.aws.secretsmanager.SecretVersion,
) : KotlinCustomResource(javaResource, SecretVersionMapper) {
    /**
     * The ARN of the secret.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies binary data that you want to encrypt and store in this version of the secret. This is required if secret_string is not set. Needs to be encoded to base64.
     */
    public val secretBinary: Output<String>?
        get() = javaResource.secretBinary().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the secret to which you want to add a new version. You can specify either the Amazon Resource Name (ARN) or the friendly name of the secret. The secret must already exist.
     */
    public val secretId: Output<String>
        get() = javaResource.secretId().applyValue({ args0 -> args0 })

    /**
     * Specifies text data that you want to encrypt and store in this version of the secret. This is required if secret_binary is not set.
     */
    public val secretString: Output<String>?
        get() = javaResource.secretString().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique identifier of the version of the secret.
     */
    public val versionId: Output<String>
        get() = javaResource.versionId().applyValue({ args0 -> args0 })

    /**
     * Specifies a list of staging labels that are attached to this version of the secret. A staging label must be unique to a single version of the secret. If you specify a staging label that's already associated with a different version of the same secret then that staging label is automatically removed from the other version and attached to this version. If you do not specify a value, then AWS Secrets Manager automatically moves the staging label `AWSCURRENT` to this new version on creation.
     * > **NOTE:** If `version_stages` is configured, you must include the `AWSCURRENT` staging label if this secret version is the only version or if the label is currently present on this secret version, otherwise this provider will show a perpetual difference.
     */
    public val versionStages: Output<List<String>>
        get() = javaResource.versionStages().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object SecretVersionMapper : ResourceMapper<SecretVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.secretsmanager.SecretVersion::class == javaResource::class

    override fun map(javaResource: Resource): SecretVersion = SecretVersion(
        javaResource as
            com.pulumi.aws.secretsmanager.SecretVersion,
    )
}

/**
 * @see [SecretVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecretVersion].
 */
public suspend fun secretVersion(
    name: String,
    block: suspend SecretVersionResourceBuilder.() -> Unit,
): SecretVersion {
    val builder = SecretVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecretVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secretVersion(name: String): SecretVersion {
    val builder = SecretVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
