@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin

import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getRandomPasswordPlain
import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getSecretPlain
import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getSecretRotationPlain
import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getSecretVersionPlain
import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions.getSecretsPlain
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetRandomPasswordPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetRandomPasswordPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretRotationPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretRotationPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretVersionPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretVersionPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretsFilter
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretsPlainArgs
import com.pulumi.aws.secretsmanager.kotlin.inputs.GetSecretsPlainArgsBuilder
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetRandomPasswordResult
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretResult
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretRotationResult
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretVersionResult
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetRandomPasswordResult.Companion.toKotlin as getRandomPasswordResultToKotlin
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretResult.Companion.toKotlin as getSecretResultToKotlin
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretRotationResult.Companion.toKotlin as getSecretRotationResultToKotlin
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretVersionResult.Companion.toKotlin as getSecretVersionResultToKotlin
import com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretsResult.Companion.toKotlin as getSecretsResultToKotlin

public object SecretsmanagerFunctions {
    /**
     * Generate a random password.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetRandomPasswordArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = SecretsmanagerFunctions.getRandomPassword(GetRandomPasswordArgs.builder()
     *             .excludeNumbers(true)
     *             .passwordLength(50)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRandomPassword.
     * @return A collection of values returned by getRandomPassword.
     */
    public suspend fun getRandomPassword(argument: GetRandomPasswordPlainArgs):
        GetRandomPasswordResult =
        getRandomPasswordResultToKotlin(getRandomPasswordPlain(argument.toJava()).await())

    /**
     * @see [getRandomPassword].
     * @param excludeCharacters String of the characters that you don't want in the password.
     * @param excludeLowercase Specifies whether to exclude lowercase letters from the password.
     * @param excludeNumbers Specifies whether to exclude numbers from the password.
     * @param excludePunctuation Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \ ] ^ _ ` { | } ~ .``
     * @param excludeUppercase Specifies whether to exclude uppercase letters from the password.
     * @param includeSpace Specifies whether to include the space character.
     * @param passwordLength Length of the password.
     * @param randomPassword Random password.
     * @param requireEachIncludedType Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
     * @return A collection of values returned by getRandomPassword.
     */
    public suspend fun getRandomPassword(
        excludeCharacters: String? = null,
        excludeLowercase: Boolean? = null,
        excludeNumbers: Boolean? = null,
        excludePunctuation: Boolean? = null,
        excludeUppercase: Boolean? = null,
        includeSpace: Boolean? = null,
        passwordLength: Int? = null,
        randomPassword: String? = null,
        requireEachIncludedType: Boolean? = null,
    ): GetRandomPasswordResult {
        val argument = GetRandomPasswordPlainArgs(
            excludeCharacters = excludeCharacters,
            excludeLowercase = excludeLowercase,
            excludeNumbers = excludeNumbers,
            excludePunctuation = excludePunctuation,
            excludeUppercase = excludeUppercase,
            includeSpace = includeSpace,
            passwordLength = passwordLength,
            randomPassword = randomPassword,
            requireEachIncludedType = requireEachIncludedType,
        )
        return getRandomPasswordResultToKotlin(getRandomPasswordPlain(argument.toJava()).await())
    }

    /**
     * @see [getRandomPassword].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetRandomPasswordPlainArgs].
     * @return A collection of values returned by getRandomPassword.
     */
    public suspend
    fun getRandomPassword(argument: suspend GetRandomPasswordPlainArgsBuilder.() -> Unit):
        GetRandomPasswordResult {
        val builder = GetRandomPasswordPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRandomPasswordResultToKotlin(getRandomPasswordPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve metadata information about a Secrets Manager secret. To retrieve a secret value, see the `aws.secretsmanager.SecretVersion` data source.
     * ## Example Usage
     * ### ARN
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var by-arn = SecretsmanagerFunctions.getSecret(GetSecretArgs.builder()
     *             .arn("arn:aws:secretsmanager:us-east-1:123456789012:secret:example-123456")
     *             .build());
     *     }
     * }
     * ```
     * ### Name
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var by-name = SecretsmanagerFunctions.getSecret(GetSecretArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSecret.
     * @return A collection of values returned by getSecret.
     */
    public suspend fun getSecret(argument: GetSecretPlainArgs): GetSecretResult =
        getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())

    /**
     * @see [getSecret].
     * @param arn ARN of the secret to retrieve.
     * @param name Name of the secret to retrieve.
     * @return A collection of values returned by getSecret.
     */
    public suspend fun getSecret(arn: String? = null, name: String? = null): GetSecretResult {
        val argument = GetSecretPlainArgs(
            arn = arn,
            name = name,
        )
        return getSecretResultToKotlin(getSecretPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecret].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetSecretPlainArgs].
     * @return A collection of values returned by getSecret.
     */
    public suspend fun getSecret(argument: suspend GetSecretPlainArgsBuilder.() -> Unit):
        GetSecretResult {
        val builder = GetSecretPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretResultToKotlin(getSecretPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Secrets Manager secret rotation. To retrieve secret metadata, see the `aws.secretsmanager.Secret` data source. To retrieve a secret value, see the `aws.secretsmanager.SecretVersion` data source.
     * ## Example Usage
     * ### Retrieve Secret Rotation Configuration
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretRotationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SecretsmanagerFunctions.getSecretRotation(GetSecretRotationArgs.builder()
     *             .secretId(data.aws_secretsmanager_secret().example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSecretRotation.
     * @return A collection of values returned by getSecretRotation.
     */
    public suspend fun getSecretRotation(argument: GetSecretRotationPlainArgs):
        GetSecretRotationResult =
        getSecretRotationResultToKotlin(getSecretRotationPlain(argument.toJava()).await())

    /**
     * @see [getSecretRotation].
     * @param secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     * @return A collection of values returned by getSecretRotation.
     */
    public suspend fun getSecretRotation(secretId: String): GetSecretRotationResult {
        val argument = GetSecretRotationPlainArgs(
            secretId = secretId,
        )
        return getSecretRotationResultToKotlin(getSecretRotationPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecretRotation].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetSecretRotationPlainArgs].
     * @return A collection of values returned by getSecretRotation.
     */
    public suspend
    fun getSecretRotation(argument: suspend GetSecretRotationPlainArgsBuilder.() -> Unit):
        GetSecretRotationResult {
        val builder = GetSecretRotationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretRotationResultToKotlin(getSecretRotationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Secrets Manager secret version, including its secret value. To retrieve secret metadata, see the `aws.secretsmanager.Secret` data source.
     * ## Example Usage
     * ### Retrieve Current Secret Version
     * By default, this data sources retrieves information based on the `AWSCURRENT` staging label.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var secret-version = SecretsmanagerFunctions.getSecretVersion(GetSecretVersionArgs.builder()
     *             .secretId(data.aws_secretsmanager_secret().example().id())
     *             .build());
     *     }
     * }
     * ```
     * ### Retrieve Specific Secret Version
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var by-version-stage = SecretsmanagerFunctions.getSecretVersion(GetSecretVersionArgs.builder()
     *             .secretId(data.aws_secretsmanager_secret().example().id())
     *             .versionStage("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSecretVersion.
     * @return A collection of values returned by getSecretVersion.
     */
    public suspend fun getSecretVersion(argument: GetSecretVersionPlainArgs): GetSecretVersionResult =
        getSecretVersionResultToKotlin(getSecretVersionPlain(argument.toJava()).await())

    /**
     * @see [getSecretVersion].
     * @param secretId Specifies the secret containing the version that you want to retrieve. You can specify either the ARN or the friendly name of the secret.
     * @param versionId Specifies the unique identifier of the version of the secret that you want to retrieve. Overrides `version_stage`.
     * @param versionStage Specifies the secret version that you want to retrieve by the staging label attached to the version. Defaults to `AWSCURRENT`.
     * @return A collection of values returned by getSecretVersion.
     */
    public suspend fun getSecretVersion(
        secretId: String,
        versionId: String? = null,
        versionStage: String? = null,
    ): GetSecretVersionResult {
        val argument = GetSecretVersionPlainArgs(
            secretId = secretId,
            versionId = versionId,
            versionStage = versionStage,
        )
        return getSecretVersionResultToKotlin(getSecretVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecretVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetSecretVersionPlainArgs].
     * @return A collection of values returned by getSecretVersion.
     */
    public suspend
    fun getSecretVersion(argument: suspend GetSecretVersionPlainArgsBuilder.() -> Unit):
        GetSecretVersionResult {
        val builder = GetSecretVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretVersionResultToKotlin(getSecretVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARNs and names of Secrets Manager secrets matching the specified criteria.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.secretsmanager.SecretsmanagerFunctions;
     * import com.pulumi.aws.secretsmanager.inputs.GetSecretsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SecretsmanagerFunctions.getSecrets(GetSecretsArgs.builder()
     *             .filters(GetSecretsFilterArgs.builder()
     *                 .name("name")
     *                 .values("example")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSecrets.
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(argument: GetSecretsPlainArgs): GetSecretsResult =
        getSecretsResultToKotlin(getSecretsPlain(argument.toJava()).await())

    /**
     * @see [getSecrets].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(filters: List<GetSecretsFilter>? = null): GetSecretsResult {
        val argument = GetSecretsPlainArgs(
            filters = filters,
        )
        return getSecretsResultToKotlin(getSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;secretsmanager&#46;kotlin&#46;inputs&#46;GetSecretsPlainArgs].
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(argument: suspend GetSecretsPlainArgsBuilder.() -> Unit):
        GetSecretsResult {
        val builder = GetSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretsResultToKotlin(getSecretsPlain(builtArgument.toJava()).await())
    }
}
