@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.inputs

import com.pulumi.aws.secretsmanager.inputs.GetRandomPasswordPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRandomPassword.
 * @property excludeCharacters String of the characters that you don't want in the password.
 * @property excludeLowercase Specifies whether to exclude lowercase letters from the password.
 * @property excludeNumbers Specifies whether to exclude numbers from the password.
 * @property excludePunctuation Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \ ] ^ _ ` { | } ~ .``
 * @property excludeUppercase Specifies whether to exclude uppercase letters from the password.
 * @property includeSpace Specifies whether to include the space character.
 * @property passwordLength Length of the password.
 * @property randomPassword Random password.
 * @property requireEachIncludedType Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
 */
public data class GetRandomPasswordPlainArgs(
    public val excludeCharacters: String? = null,
    public val excludeLowercase: Boolean? = null,
    public val excludeNumbers: Boolean? = null,
    public val excludePunctuation: Boolean? = null,
    public val excludeUppercase: Boolean? = null,
    public val includeSpace: Boolean? = null,
    public val passwordLength: Int? = null,
    public val randomPassword: String? = null,
    public val requireEachIncludedType: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.inputs.GetRandomPasswordPlainArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.inputs.GetRandomPasswordPlainArgs =
        com.pulumi.aws.secretsmanager.inputs.GetRandomPasswordPlainArgs.builder()
            .excludeCharacters(excludeCharacters?.let({ args0 -> args0 }))
            .excludeLowercase(excludeLowercase?.let({ args0 -> args0 }))
            .excludeNumbers(excludeNumbers?.let({ args0 -> args0 }))
            .excludePunctuation(excludePunctuation?.let({ args0 -> args0 }))
            .excludeUppercase(excludeUppercase?.let({ args0 -> args0 }))
            .includeSpace(includeSpace?.let({ args0 -> args0 }))
            .passwordLength(passwordLength?.let({ args0 -> args0 }))
            .randomPassword(randomPassword?.let({ args0 -> args0 }))
            .requireEachIncludedType(requireEachIncludedType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRandomPasswordPlainArgs].
 */
@PulumiTagMarker
public class GetRandomPasswordPlainArgsBuilder internal constructor() {
    private var excludeCharacters: String? = null

    private var excludeLowercase: Boolean? = null

    private var excludeNumbers: Boolean? = null

    private var excludePunctuation: Boolean? = null

    private var excludeUppercase: Boolean? = null

    private var includeSpace: Boolean? = null

    private var passwordLength: Int? = null

    private var randomPassword: String? = null

    private var requireEachIncludedType: Boolean? = null

    /**
     * @param value String of the characters that you don't want in the password.
     */
    @JvmName("khscqhsstivnnvwi")
    public suspend fun excludeCharacters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.excludeCharacters = mapped
    }

    /**
     * @param value Specifies whether to exclude lowercase letters from the password.
     */
    @JvmName("yknykvdnrxbwaxnd")
    public suspend fun excludeLowercase(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.excludeLowercase = mapped
    }

    /**
     * @param value Specifies whether to exclude numbers from the password.
     */
    @JvmName("xxydonvydlkplotv")
    public suspend fun excludeNumbers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.excludeNumbers = mapped
    }

    /**
     * @param value Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \ ] ^ _ ` { | } ~ .``
     */
    @JvmName("kbkihcxytrewqfdd")
    public suspend fun excludePunctuation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.excludePunctuation = mapped
    }

    /**
     * @param value Specifies whether to exclude uppercase letters from the password.
     */
    @JvmName("pvixkwcoouaknttf")
    public suspend fun excludeUppercase(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.excludeUppercase = mapped
    }

    /**
     * @param value Specifies whether to include the space character.
     */
    @JvmName("mfrahfvuapgrlgtg")
    public suspend fun includeSpace(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeSpace = mapped
    }

    /**
     * @param value Length of the password.
     */
    @JvmName("fjdneehdehrmoiir")
    public suspend fun passwordLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.passwordLength = mapped
    }

    /**
     * @param value Random password.
     */
    @JvmName("lmweguhhdqpytnua")
    public suspend fun randomPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.randomPassword = mapped
    }

    /**
     * @param value Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation.
     */
    @JvmName("qcvwhmkqpdwrtmoi")
    public suspend fun requireEachIncludedType(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.requireEachIncludedType = mapped
    }

    internal fun build(): GetRandomPasswordPlainArgs = GetRandomPasswordPlainArgs(
        excludeCharacters = excludeCharacters,
        excludeLowercase = excludeLowercase,
        excludeNumbers = excludeNumbers,
        excludePunctuation = excludePunctuation,
        excludeUppercase = excludeUppercase,
        includeSpace = includeSpace,
        passwordLength = passwordLength,
        randomPassword = randomPassword,
        requireEachIncludedType = requireEachIncludedType,
    )
}
