@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.inputs

import com.pulumi.aws.secretsmanager.inputs.GetSecretPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSecret.
 * @property arn ARN of the secret to retrieve.
 * @property name Name of the secret to retrieve.
 */
public data class GetSecretPlainArgs(
    public val arn: String? = null,
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.inputs.GetSecretPlainArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.inputs.GetSecretPlainArgs =
        com.pulumi.aws.secretsmanager.inputs.GetSecretPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecretPlainArgs].
 */
@PulumiTagMarker
public class GetSecretPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var name: String? = null

    /**
     * @param value ARN of the secret to retrieve.
     */
    @JvmName("ysfnddroelsosppk")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Name of the secret to retrieve.
     */
    @JvmName("aqjdjevlvupmrenh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetSecretPlainArgs = GetSecretPlainArgs(
        arn = arn,
        name = name,
    )
}
