@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.inputs

import com.pulumi.aws.secretsmanager.inputs.SecretRotationRotationRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property automaticallyAfterDays Specifies the number of days between automatic scheduled rotations of the secret. Either `automatically_after_days` or `schedule_expression` must be specified.
 * @property duration The length of the rotation window in hours. For example, `3h` for a three hour window.
 * @property scheduleExpression A `cron()` or `rate()` expression that defines the schedule for rotating your secret. Either `automatically_after_days` or `schedule_expression` must be specified.
 */
public data class SecretRotationRotationRulesArgs(
    public val automaticallyAfterDays: Output<Int>? = null,
    public val duration: Output<String>? = null,
    public val scheduleExpression: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.secretsmanager.inputs.SecretRotationRotationRulesArgs> {
    override fun toJava(): com.pulumi.aws.secretsmanager.inputs.SecretRotationRotationRulesArgs =
        com.pulumi.aws.secretsmanager.inputs.SecretRotationRotationRulesArgs.builder()
            .automaticallyAfterDays(automaticallyAfterDays?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .scheduleExpression(scheduleExpression?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretRotationRotationRulesArgs].
 */
@PulumiTagMarker
public class SecretRotationRotationRulesArgsBuilder internal constructor() {
    private var automaticallyAfterDays: Output<Int>? = null

    private var duration: Output<String>? = null

    private var scheduleExpression: Output<String>? = null

    /**
     * @param value Specifies the number of days between automatic scheduled rotations of the secret. Either `automatically_after_days` or `schedule_expression` must be specified.
     */
    @JvmName("ibwblqeuatqgwxft")
    public suspend fun automaticallyAfterDays(`value`: Output<Int>) {
        this.automaticallyAfterDays = value
    }

    /**
     * @param value The length of the rotation window in hours. For example, `3h` for a three hour window.
     */
    @JvmName("ligkxtyethpdfmav")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value A `cron()` or `rate()` expression that defines the schedule for rotating your secret. Either `automatically_after_days` or `schedule_expression` must be specified.
     */
    @JvmName("ceamegmsgblmrtml")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value Specifies the number of days between automatic scheduled rotations of the secret. Either `automatically_after_days` or `schedule_expression` must be specified.
     */
    @JvmName("fpcrpmdbgasvixnv")
    public suspend fun automaticallyAfterDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticallyAfterDays = mapped
    }

    /**
     * @param value The length of the rotation window in hours. For example, `3h` for a three hour window.
     */
    @JvmName("txblbjygyugcbpjr")
    public suspend fun duration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value A `cron()` or `rate()` expression that defines the schedule for rotating your secret. Either `automatically_after_days` or `schedule_expression` must be specified.
     */
    @JvmName("iokgbxfosunlbitu")
    public suspend fun scheduleExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    internal fun build(): SecretRotationRotationRulesArgs = SecretRotationRotationRulesArgs(
        automaticallyAfterDays = automaticallyAfterDays,
        duration = duration,
        scheduleExpression = scheduleExpression,
    )
}
