@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSecretRotation.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property rotationEnabled ARN of the secret.
 * @property rotationLambdaArn Decrypted part of the protected secret information that was originally provided as a string.
 * @property rotationRules Decrypted part of the protected secret information that was originally provided as a binary. Base64 encoded.
 * @property secretId
 */
public data class GetSecretRotationResult(
    public val id: String,
    public val rotationEnabled: Boolean,
    public val rotationLambdaArn: String,
    public val rotationRules: List<GetSecretRotationRotationRule>,
    public val secretId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.secretsmanager.outputs.GetSecretRotationResult):
            GetSecretRotationResult = GetSecretRotationResult(
            id = javaType.id(),
            rotationEnabled = javaType.rotationEnabled(),
            rotationLambdaArn = javaType.rotationLambdaArn(),
            rotationRules = javaType.rotationRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretRotationRotationRule.Companion.toKotlin(args0)
                })
            }),
            secretId = javaType.secretId(),
        )
    }
}
