@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSecrets.
 * @property arns Set of ARNs of the matched Secrets Manager secrets.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names Set of names of the matched Secrets Manager secrets.
 */
public data class GetSecretsResult(
    public val arns: List<String>,
    public val filters: List<GetSecretsFilter>? = null,
    public val id: String,
    public val names: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.secretsmanager.outputs.GetSecretsResult):
            GetSecretsResult = GetSecretsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.secretsmanager.kotlin.outputs.GetSecretsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
        )
    }
}
