@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId ARN, Key ID, or Alias of the AWS KMS key within the region secret is replicated to. If one is not specified, then Secrets Manager defaults to using the AWS account's default KMS key (`aws/secretsmanager`) in the region or creates one for use if non-existent.
 * @property lastAccessedDate Date that you last accessed the secret in the Region.
 * @property region Region for replicating the secret.
 * @property status Status can be `InProgress`, `Failed`, or `InSync`.
 * @property statusMessage Message such as `Replication succeeded` or `Secret with this name already exists in this region`.
 */
public data class SecretReplica(
    public val kmsKeyId: String? = null,
    public val lastAccessedDate: String? = null,
    public val region: String,
    public val status: String? = null,
    public val statusMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.secretsmanager.outputs.SecretReplica):
            SecretReplica = SecretReplica(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            lastAccessedDate = javaType.lastAccessedDate().map({ args0 -> args0 }).orElse(null),
            region = javaType.region(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            statusMessage = javaType.statusMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
