@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.secretsmanager.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property automaticallyAfterDays Specifies the number of days between automatic scheduled rotations of the secret. Either `automatically_after_days` or `schedule_expression` must be specified.
 * @property duration The length of the rotation window in hours. For example, `3h` for a three hour window.
 * @property scheduleExpression A `cron()` or `rate()` expression that defines the schedule for rotating your secret. Either `automatically_after_days` or `schedule_expression` must be specified.
 */
public data class SecretRotationRotationRules(
    public val automaticallyAfterDays: Int? = null,
    public val duration: String? = null,
    public val scheduleExpression: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.secretsmanager.outputs.SecretRotationRotationRules):
            SecretRotationRotationRules = SecretRotationRotationRules(
            automaticallyAfterDays = javaType.automaticallyAfterDays().map({ args0 -> args0 }).orElse(null),
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            scheduleExpression = javaType.scheduleExpression().map({ args0 -> args0 }).orElse(null),
        )
    }
}
