@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.ActionTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates Security Hub custom action.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.ActionTarget;
 * import com.pulumi.aws.securityhub.ActionTargetArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleActionTarget = new ActionTarget("exampleActionTarget", ActionTargetArgs.builder()
 *             .identifier("SendToChat")
 *             .description("This is custom action sends selected findings to chat")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Hub custom action using the action target ARN. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/actionTarget:ActionTarget example arn:aws:securityhub:eu-west-1:312940875350:action/custom/a
 * ```
 * @property description The name of the custom action target.
 * @property identifier The ID for the custom action target.
 * @property name The description for the custom action target.
 */
public data class ActionTargetArgs(
    public val description: Output<String>? = null,
    public val identifier: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.ActionTargetArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.ActionTargetArgs =
        com.pulumi.aws.securityhub.ActionTargetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .identifier(identifier?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActionTargetArgs].
 */
@PulumiTagMarker
public class ActionTargetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var identifier: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The name of the custom action target.
     */
    @JvmName("gokypdumfmngalvk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID for the custom action target.
     */
    @JvmName("pgpdukyrrvcfduwg")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value The description for the custom action target.
     */
    @JvmName("fuqcbxboitrqtwwr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the custom action target.
     */
    @JvmName("uligeydyrevlogle")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID for the custom action target.
     */
    @JvmName("cdumjlcafosjbktd")
    public suspend fun identifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value The description for the custom action target.
     */
    @JvmName("gueqtbjeccnvvsum")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ActionTargetArgs = ActionTargetArgs(
        description = description,
        identifier = identifier,
        name = name,
    )
}
