@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [FindingAggregator].
 */
@PulumiTagMarker
public class FindingAggregatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FindingAggregatorArgs = FindingAggregatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FindingAggregatorArgsBuilder.() -> Unit) {
        val builder = FindingAggregatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FindingAggregator {
        val builtJavaResource = com.pulumi.aws.securityhub.FindingAggregator(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FindingAggregator(builtJavaResource)
    }
}

/**
 * Manages a Security Hub finding aggregator. Security Hub needs to be enabled in a region in order for the aggregator to pull through findings.
 * ## Example Usage
 * ### All Regions Usage
 * The following example will enable the aggregator for every region.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("ALL_REGIONS")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### All Regions Except Specified Regions Usage
 * The following example will enable the aggregator for every region except those specified in `specified_regions`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("ALL_REGIONS_EXCEPT_SPECIFIED")
 *             .specifiedRegions(
 *                 "eu-west-1",
 *                 "eu-west-2")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### Specified Regions Usage
 * The following example will enable the aggregator for every region specified in `specified_regions`.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.FindingAggregator;
 * import com.pulumi.aws.securityhub.FindingAggregatorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleFindingAggregator = new FindingAggregator("exampleFindingAggregator", FindingAggregatorArgs.builder()
 *             .linkingMode("SPECIFIED_REGIONS")
 *             .specifiedRegions(
 *                 "eu-west-1",
 *                 "eu-west-2")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an existing Security Hub finding aggregator using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/findingAggregator:FindingAggregator example arn:aws:securityhub:eu-west-1:123456789098:finding-aggregator/abcd1234-abcd-1234-1234-abcdef123456
 * ```
 *
 */
public class FindingAggregator internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.FindingAggregator,
) : KotlinCustomResource(javaResource, FindingAggregatorMapper) {
    /**
     * Indicates whether to aggregate findings from all of the available Regions or from a specified list. The options are `ALL_REGIONS`, `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`. When `ALL_REGIONS` or `ALL_REGIONS_EXCEPT_SPECIFIED` are used, Security Hub will automatically aggregate findings from new Regions as Security Hub supports them and you opt into them.
     */
    public val linkingMode: Output<String>
        get() = javaResource.linkingMode().applyValue({ args0 -> args0 })

    /**
     * List of regions to include or exclude (required if `linking_mode` is set to `ALL_REGIONS_EXCEPT_SPECIFIED` or `SPECIFIED_REGIONS`)
     */
    public val specifiedRegions: Output<List<String>>?
        get() = javaResource.specifiedRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })
}

public object FindingAggregatorMapper : ResourceMapper<FindingAggregator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.FindingAggregator::class == javaResource::class

    override fun map(javaResource: Resource): FindingAggregator = FindingAggregator(
        javaResource as
            com.pulumi.aws.securityhub.FindingAggregator,
    )
}

/**
 * @see [FindingAggregator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FindingAggregator].
 */
public suspend fun findingAggregator(
    name: String,
    block: suspend FindingAggregatorResourceBuilder.() -> Unit,
): FindingAggregator {
    val builder = FindingAggregatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FindingAggregator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun findingAggregator(name: String): FindingAggregator {
    val builder = FindingAggregatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
