@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.kotlin.outputs.InsightFilters
import com.pulumi.aws.securityhub.kotlin.outputs.InsightFilters.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Insight].
 */
@PulumiTagMarker
public class InsightResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InsightArgs = InsightArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InsightArgsBuilder.() -> Unit) {
        val builder = InsightArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Insight {
        val builtJavaResource = com.pulumi.aws.securityhub.Insight(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Insight(builtJavaResource)
    }
}

/**
 * Provides a Security Hub custom insight resource. See the [Managing custom insights section](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-insights.html) of the AWS User Guide for more information.
 * ## Example Usage
 * ### Filter by AWS account ID
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .awsAccountIds(
 *                     InsightFiltersAwsAccountIdArgs.builder()
 *                         .comparison("EQUALS")
 *                         .value("1234567890")
 *                         .build(),
 *                     InsightFiltersAwsAccountIdArgs.builder()
 *                         .comparison("EQUALS")
 *                         .value("09876543210")
 *                         .build())
 *                 .build())
 *             .groupByAttribute("AwsAccountId")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### Filter by date range
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .createdAts(InsightFiltersCreatedAtArgs.builder()
 *                     .dateRange(InsightFiltersCreatedAtDateRangeArgs.builder()
 *                         .unit("DAYS")
 *                         .value(5)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .groupByAttribute("CreatedAt")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### Filter by destination IPv4 address
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .networkDestinationIpv4s(InsightFiltersNetworkDestinationIpv4Args.builder()
 *                     .cidr("10.0.0.0/16")
 *                     .build())
 *                 .build())
 *             .groupByAttribute("NetworkDestinationIpV4")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### Filter by finding's confidence
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .confidences(InsightFiltersConfidenceArgs.builder()
 *                     .gte("80")
 *                     .build())
 *                 .build())
 *             .groupByAttribute("Confidence")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### Filter by resource tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .resourceTags(InsightFiltersResourceTagArgs.builder()
 *                     .comparison("EQUALS")
 *                     .key("Environment")
 *                     .value("Production")
 *                     .build())
 *                 .build())
 *             .groupByAttribute("ResourceTags")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Hub insights using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/insight:Insight example arn:aws:securityhub:us-west-2:1234567890:insight/1234567890/custom/91299ed7-abd0-4e44-a858-d0b15e37141a
 * ```
 *
 */
public class Insight internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.Insight,
) : KotlinCustomResource(javaResource, InsightMapper) {
    /**
     * ARN of the insight.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A configuration block including one or more (up to 10 distinct) attributes used to filter the findings included in the insight. The insight only includes findings that match criteria defined in the filters. See filters below for more details.
     */
    public val filters: Output<InsightFilters>
        get() = javaResource.filters().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The attribute used to group the findings for the insight e.g., if an insight is grouped by `ResourceId`, then the insight produces a list of resource identifiers.
     */
    public val groupByAttribute: Output<String>
        get() = javaResource.groupByAttribute().applyValue({ args0 -> args0 })

    /**
     * The name of the custom insight.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object InsightMapper : ResourceMapper<Insight> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.Insight::class == javaResource::class

    override fun map(javaResource: Resource): Insight = Insight(
        javaResource as
            com.pulumi.aws.securityhub.Insight,
    )
}

/**
 * @see [Insight].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Insight].
 */
public suspend fun insight(name: String, block: suspend InsightResourceBuilder.() -> Unit):
    Insight {
    val builder = InsightResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Insight].
 * @param name The _unique_ name of the resulting resource.
 */
public fun insight(name: String): Insight {
    val builder = InsightResourceBuilder()
    builder.name(name)
    return builder.build()
}
