@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.InsightArgs.builder
import com.pulumi.aws.securityhub.kotlin.inputs.InsightFiltersArgs
import com.pulumi.aws.securityhub.kotlin.inputs.InsightFiltersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Security Hub custom insight resource. See the [Managing custom insights section](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-insights.html) of the AWS User Guide for more information.
 * ## Example Usage
 * ### Filter by AWS account ID
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .awsAccountIds(
 *                     InsightFiltersAwsAccountIdArgs.builder()
 *                         .comparison("EQUALS")
 *                         .value("1234567890")
 *                         .build(),
 *                     InsightFiltersAwsAccountIdArgs.builder()
 *                         .comparison("EQUALS")
 *                         .value("09876543210")
 *                         .build())
 *                 .build())
 *             .groupByAttribute("AwsAccountId")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### Filter by date range
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .createdAts(InsightFiltersCreatedAtArgs.builder()
 *                     .dateRange(InsightFiltersCreatedAtDateRangeArgs.builder()
 *                         .unit("DAYS")
 *                         .value(5)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .groupByAttribute("CreatedAt")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### Filter by destination IPv4 address
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .networkDestinationIpv4s(InsightFiltersNetworkDestinationIpv4Args.builder()
 *                     .cidr("10.0.0.0/16")
 *                     .build())
 *                 .build())
 *             .groupByAttribute("NetworkDestinationIpV4")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### Filter by finding's confidence
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .confidences(InsightFiltersConfidenceArgs.builder()
 *                     .gte("80")
 *                     .build())
 *                 .build())
 *             .groupByAttribute("Confidence")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ### Filter by resource tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Insight;
 * import com.pulumi.aws.securityhub.InsightArgs;
 * import com.pulumi.aws.securityhub.inputs.InsightFiltersArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleInsight = new Insight("exampleInsight", InsightArgs.builder()
 *             .filters(InsightFiltersArgs.builder()
 *                 .resourceTags(InsightFiltersResourceTagArgs.builder()
 *                     .comparison("EQUALS")
 *                     .key("Environment")
 *                     .value("Production")
 *                     .build())
 *                 .build())
 *             .groupByAttribute("ResourceTags")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Hub insights using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/insight:Insight example arn:aws:securityhub:us-west-2:1234567890:insight/1234567890/custom/91299ed7-abd0-4e44-a858-d0b15e37141a
 * ```
 * @property filters A configuration block including one or more (up to 10 distinct) attributes used to filter the findings included in the insight. The insight only includes findings that match criteria defined in the filters. See filters below for more details.
 * @property groupByAttribute The attribute used to group the findings for the insight e.g., if an insight is grouped by `ResourceId`, then the insight produces a list of resource identifiers.
 * @property name The name of the custom insight.
 */
public data class InsightArgs(
    public val filters: Output<InsightFiltersArgs>? = null,
    public val groupByAttribute: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.InsightArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.InsightArgs =
        com.pulumi.aws.securityhub.InsightArgs.builder()
            .filters(filters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .groupByAttribute(groupByAttribute?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightArgs].
 */
@PulumiTagMarker
public class InsightArgsBuilder internal constructor() {
    private var filters: Output<InsightFiltersArgs>? = null

    private var groupByAttribute: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value A configuration block including one or more (up to 10 distinct) attributes used to filter the findings included in the insight. The insight only includes findings that match criteria defined in the filters. See filters below for more details.
     */
    @JvmName("palxhbiyxpjmqsaa")
    public suspend fun filters(`value`: Output<InsightFiltersArgs>) {
        this.filters = value
    }

    /**
     * @param value The attribute used to group the findings for the insight e.g., if an insight is grouped by `ResourceId`, then the insight produces a list of resource identifiers.
     */
    @JvmName("cwslveoshycolxtc")
    public suspend fun groupByAttribute(`value`: Output<String>) {
        this.groupByAttribute = value
    }

    /**
     * @param value The name of the custom insight.
     */
    @JvmName("kalcpfqrhnvmybyq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A configuration block including one or more (up to 10 distinct) attributes used to filter the findings included in the insight. The insight only includes findings that match criteria defined in the filters. See filters below for more details.
     */
    @JvmName("ntosfwnbfglkigxd")
    public suspend fun filters(`value`: InsightFiltersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument A configuration block including one or more (up to 10 distinct) attributes used to filter the findings included in the insight. The insight only includes findings that match criteria defined in the filters. See filters below for more details.
     */
    @JvmName("fbsfgmilemvrnaee")
    public suspend fun filters(argument: suspend InsightFiltersArgsBuilder.() -> Unit) {
        val toBeMapped = InsightFiltersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param value The attribute used to group the findings for the insight e.g., if an insight is grouped by `ResourceId`, then the insight produces a list of resource identifiers.
     */
    @JvmName("rujdtgojqkyyuvpi")
    public suspend fun groupByAttribute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupByAttribute = mapped
    }

    /**
     * @param value The name of the custom insight.
     */
    @JvmName("qsuswrcdsryhqumt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): InsightArgs = InsightArgs(
        filters = filters,
        groupByAttribute = groupByAttribute,
        name = name,
    )
}
