@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.InviteAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **Note:** AWS accounts can only be associated with a single Security Hub master account. Destroying this resource will disassociate the member account from the master account.
 * Accepts a Security Hub invitation.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Member;
 * import com.pulumi.aws.securityhub.MemberArgs;
 * import com.pulumi.aws.securityhub.AccountArgs;
 * import com.pulumi.aws.securityhub.InviteAccepter;
 * import com.pulumi.aws.securityhub.InviteAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleMember = new Member("exampleMember", MemberArgs.builder()
 *             .accountId("123456789012")
 *             .email("example@example.com")
 *             .invite(true)
 *             .build());
 *         var inviteeAccount = new Account("inviteeAccount", AccountArgs.Empty, CustomResourceOptions.builder()
 *             .provider("aws.invitee")
 *             .build());
 *         var inviteeInviteAccepter = new InviteAccepter("inviteeInviteAccepter", InviteAccepterArgs.builder()
 *             .masterId(exampleMember.masterId())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("aws.invitee")
 *                 .dependsOn(inviteeAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Hub invite acceptance using the account ID. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/inviteAccepter:InviteAccepter example 123456789012
 * ```
 * @property masterId The account ID of the master Security Hub account whose invitation you're accepting.
 */
public data class InviteAccepterArgs(
    public val masterId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.InviteAccepterArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.InviteAccepterArgs =
        com.pulumi.aws.securityhub.InviteAccepterArgs.builder()
            .masterId(masterId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InviteAccepterArgs].
 */
@PulumiTagMarker
public class InviteAccepterArgsBuilder internal constructor() {
    private var masterId: Output<String>? = null

    /**
     * @param value The account ID of the master Security Hub account whose invitation you're accepting.
     */
    @JvmName("betxjnretbsniwis")
    public suspend fun masterId(`value`: Output<String>) {
        this.masterId = value
    }

    /**
     * @param value The account ID of the master Security Hub account whose invitation you're accepting.
     */
    @JvmName("qmeboijtqadwfsme")
    public suspend fun masterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterId = mapped
    }

    internal fun build(): InviteAccepterArgs = InviteAccepterArgs(
        masterId = masterId,
    )
}
