@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Member].
 */
@PulumiTagMarker
public class MemberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MemberArgs = MemberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MemberArgsBuilder.() -> Unit) {
        val builder = MemberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Member {
        val builtJavaResource = com.pulumi.aws.securityhub.Member(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Member(builtJavaResource)
    }
}

/**
 * Provides a Security Hub member resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Member;
 * import com.pulumi.aws.securityhub.MemberArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleMember = new Member("exampleMember", MemberArgs.builder()
 *             .accountId("123456789012")
 *             .email("example@example.com")
 *             .invite(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Hub members using their account ID. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/member:Member example 123456789012
 * ```
 *
 */
public class Member internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.Member,
) : KotlinCustomResource(javaResource, MemberMapper) {
    /**
     * The ID of the member AWS account.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The email of the member AWS account.
     */
    public val email: Output<String>?
        get() = javaResource.email().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
     */
    public val invite: Output<Boolean>?
        get() = javaResource.invite().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the master Security Hub AWS account.
     */
    public val masterId: Output<String>
        get() = javaResource.masterId().applyValue({ args0 -> args0 })

    /**
     * The status of the member account relationship.
     */
    public val memberStatus: Output<String>
        get() = javaResource.memberStatus().applyValue({ args0 -> args0 })
}

public object MemberMapper : ResourceMapper<Member> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.Member::class == javaResource::class

    override fun map(javaResource: Resource): Member = Member(
        javaResource as
            com.pulumi.aws.securityhub.Member,
    )
}

/**
 * @see [Member].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Member].
 */
public suspend fun member(name: String, block: suspend MemberResourceBuilder.() -> Unit): Member {
    val builder = MemberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Member].
 * @param name The _unique_ name of the resulting resource.
 */
public fun member(name: String): Member {
    val builder = MemberResourceBuilder()
    builder.name(name)
    return builder.build()
}
