@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.MemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Security Hub member resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.Member;
 * import com.pulumi.aws.securityhub.MemberArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleMember = new Member("exampleMember", MemberArgs.builder()
 *             .accountId("123456789012")
 *             .email("example@example.com")
 *             .invite(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Hub members using their account ID. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/member:Member example 123456789012
 * ```
 * @property accountId The ID of the member AWS account.
 * @property email The email of the member AWS account.
 * @property invite Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
 */
public data class MemberArgs(
    public val accountId: Output<String>? = null,
    public val email: Output<String>? = null,
    public val invite: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.MemberArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.MemberArgs =
        com.pulumi.aws.securityhub.MemberArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .invite(invite?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MemberArgs].
 */
@PulumiTagMarker
public class MemberArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var email: Output<String>? = null

    private var invite: Output<Boolean>? = null

    /**
     * @param value The ID of the member AWS account.
     */
    @JvmName("msqgtuyyxeienpyn")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The email of the member AWS account.
     */
    @JvmName("gjunekdeaehokhlp")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
     */
    @JvmName("rgsjhtiwfkgaeuau")
    public suspend fun invite(`value`: Output<Boolean>) {
        this.invite = value
    }

    /**
     * @param value The ID of the member AWS account.
     */
    @JvmName("gngnamojosxfwtgi")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The email of the member AWS account.
     */
    @JvmName("umpxheomobbavfpq")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Boolean whether to invite the account to Security Hub as a member. Defaults to `false`.
     */
    @JvmName("djvcoqwfpotfbdyb")
    public suspend fun invite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invite = mapped
    }

    internal fun build(): MemberArgs = MemberArgs(
        accountId = accountId,
        email = email,
        invite = invite,
    )
}
