@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationConfiguration].
 */
@PulumiTagMarker
public class OrganizationConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationConfigurationArgs = OrganizationConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationConfigurationArgsBuilder.() -> Unit) {
        val builder = OrganizationConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OrganizationConfiguration {
        val builtJavaResource =
            com.pulumi.aws.securityhub.OrganizationConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationConfiguration(builtJavaResource)
    }
}

/**
 * Manages the Security Hub Organization Configuration.
 * > **NOTE:** This resource requires an `aws.securityhub.OrganizationAdminAccount` to be configured (not necessarily with Pulumi). More information about managing Security Hub in an organization can be found in the [Managing administrator and member accounts](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts.html) documentation
 * > **NOTE:** This is an advanced AWS resource. Pulumi will automatically assume management of the Security Hub Organization Configuration without import and perform no actions on removal from the Pulumi program.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.securityhub.OrganizationAdminAccount;
 * import com.pulumi.aws.securityhub.OrganizationAdminAccountArgs;
 * import com.pulumi.aws.securityhub.OrganizationConfiguration;
 * import com.pulumi.aws.securityhub.OrganizationConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("securityhub.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .adminAccountId("123456789012")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleOrganization)
 *                 .build());
 *         var exampleOrganizationConfiguration = new OrganizationConfiguration("exampleOrganizationConfiguration", OrganizationConfigurationArgs.builder()
 *             .autoEnable(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an existing Security Hub enabled account using the AWS account ID. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/organizationConfiguration:OrganizationConfiguration example 123456789012
 * ```
 *
 */
public class OrganizationConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.OrganizationConfiguration,
) : KotlinCustomResource(javaResource, OrganizationConfigurationMapper) {
    /**
     * Whether to automatically enable Security Hub for new accounts in the organization.
     */
    public val autoEnable: Output<Boolean>
        get() = javaResource.autoEnable().applyValue({ args0 -> args0 })

    /**
     * Whether to automatically enable Security Hub default standards for new member accounts in the organization. By default, this parameter is equal to `DEFAULT`, and new member accounts are automatically enabled with default Security Hub standards. To opt out of enabling default standards for new member accounts, set this parameter equal to `NONE`.
     */
    public val autoEnableStandards: Output<String>
        get() = javaResource.autoEnableStandards().applyValue({ args0 -> args0 })
}

public object OrganizationConfigurationMapper : ResourceMapper<OrganizationConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.OrganizationConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationConfiguration =
        OrganizationConfiguration(
            javaResource as
                com.pulumi.aws.securityhub.OrganizationConfiguration,
        )
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationConfiguration].
 */
public suspend fun organizationConfiguration(
    name: String,
    block: suspend OrganizationConfigurationResourceBuilder.() -> Unit,
): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationConfiguration(name: String): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
