@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.aws.securityhub.OrganizationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages the Security Hub Organization Configuration.
 * > **NOTE:** This resource requires an `aws.securityhub.OrganizationAdminAccount` to be configured (not necessarily with Pulumi). More information about managing Security Hub in an organization can be found in the [Managing administrator and member accounts](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts.html) documentation
 * > **NOTE:** This is an advanced AWS resource. Pulumi will automatically assume management of the Security Hub Organization Configuration without import and perform no actions on removal from the Pulumi program.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.securityhub.OrganizationAdminAccount;
 * import com.pulumi.aws.securityhub.OrganizationAdminAccountArgs;
 * import com.pulumi.aws.securityhub.OrganizationConfiguration;
 * import com.pulumi.aws.securityhub.OrganizationConfigurationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOrganization = new Organization("exampleOrganization", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("securityhub.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .adminAccountId("123456789012")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleOrganization)
 *                 .build());
 *         var exampleOrganizationConfiguration = new OrganizationConfiguration("exampleOrganizationConfiguration", OrganizationConfigurationArgs.builder()
 *             .autoEnable(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an existing Security Hub enabled account using the AWS account ID. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/organizationConfiguration:OrganizationConfiguration example 123456789012
 * ```
 * @property autoEnable Whether to automatically enable Security Hub for new accounts in the organization.
 * @property autoEnableStandards Whether to automatically enable Security Hub default standards for new member accounts in the organization. By default, this parameter is equal to `DEFAULT`, and new member accounts are automatically enabled with default Security Hub standards. To opt out of enabling default standards for new member accounts, set this parameter equal to `NONE`.
 */
public data class OrganizationConfigurationArgs(
    public val autoEnable: Output<Boolean>? = null,
    public val autoEnableStandards: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.securityhub.OrganizationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.OrganizationConfigurationArgs =
        com.pulumi.aws.securityhub.OrganizationConfigurationArgs.builder()
            .autoEnable(autoEnable?.applyValue({ args0 -> args0 }))
            .autoEnableStandards(autoEnableStandards?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationConfigurationArgs].
 */
@PulumiTagMarker
public class OrganizationConfigurationArgsBuilder internal constructor() {
    private var autoEnable: Output<Boolean>? = null

    private var autoEnableStandards: Output<String>? = null

    /**
     * @param value Whether to automatically enable Security Hub for new accounts in the organization.
     */
    @JvmName("givdrdbwbugxjqlu")
    public suspend fun autoEnable(`value`: Output<Boolean>) {
        this.autoEnable = value
    }

    /**
     * @param value Whether to automatically enable Security Hub default standards for new member accounts in the organization. By default, this parameter is equal to `DEFAULT`, and new member accounts are automatically enabled with default Security Hub standards. To opt out of enabling default standards for new member accounts, set this parameter equal to `NONE`.
     */
    @JvmName("spkasaesjfmnfmcv")
    public suspend fun autoEnableStandards(`value`: Output<String>) {
        this.autoEnableStandards = value
    }

    /**
     * @param value Whether to automatically enable Security Hub for new accounts in the organization.
     */
    @JvmName("vdvqxnukjkaexljq")
    public suspend fun autoEnable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnable = mapped
    }

    /**
     * @param value Whether to automatically enable Security Hub default standards for new member accounts in the organization. By default, this parameter is equal to `DEFAULT`, and new member accounts are automatically enabled with default Security Hub standards. To opt out of enabling default standards for new member accounts, set this parameter equal to `NONE`.
     */
    @JvmName("ewobeybsflfaxelg")
    public suspend fun autoEnableStandards(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoEnableStandards = mapped
    }

    internal fun build(): OrganizationConfigurationArgs = OrganizationConfigurationArgs(
        autoEnable = autoEnable,
        autoEnableStandards = autoEnableStandards,
    )
}
