@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProductSubscription].
 */
@PulumiTagMarker
public class ProductSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProductSubscriptionArgs = ProductSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProductSubscriptionArgsBuilder.() -> Unit) {
        val builder = ProductSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProductSubscription {
        val builtJavaResource = com.pulumi.aws.securityhub.ProductSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProductSubscription(builtJavaResource)
    }
}

/**
 * Subscribes to a Security Hub product.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.securityhub.ProductSubscription;
 * import com.pulumi.aws.securityhub.ProductSubscriptionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         final var current = AwsFunctions.getRegion();
 *         var exampleProductSubscription = new ProductSubscription("exampleProductSubscription", ProductSubscriptionArgs.builder()
 *             .productArn(String.format("arn:aws:securityhub:%s:733251395267:product/alertlogic/althreatmanagement", current.applyValue(getRegionResult -> getRegionResult.name())))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Hub product subscriptions using `product_arn,arn`. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/productSubscription:ProductSubscription example arn:aws:securityhub:eu-west-1:733251395267:product/alertlogic/althreatmanagement,arn:aws:securityhub:eu-west-1:123456789012:product-subscription/alertlogic/althreatmanagement
 * ```
 *
 */
public class ProductSubscription internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.ProductSubscription,
) : KotlinCustomResource(javaResource, ProductSubscriptionMapper) {
    /**
     * The ARN of a resource that represents your subscription to the product that generates the findings that you want to import into Security Hub.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the product that generates findings that you want to import into Security Hub - see below.
     * Amazon maintains a list of [Product integrations in AWS Security Hub](https://docs&#46;aws&#46;amazon&#46;com/securityhub/latest/userguide/securityhub-findings-providers&#46;html) that changes over time&#46; Any of the products on the linked [Available AWS service integrations](https://docs&#46;aws&#46;amazon&#46;com/securityhub/latest/userguide/securityhub-internal-providers&#46;html) or [Available third-party partner product integrations](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-partner-providers.html) can be configured using `aws.securityhub.ProductSubscription`.
     * Available products can also be listed by running the AWS CLI command `aws securityhub describe-products`.
     * A subset of currently available products (remember to replace `${var.region}` as appropriate) includes:
     * * `arn:aws:securityhub:${var.region}::product/aws/guardduty`
     * * `arn:aws:securityhub:${var.region}::product/aws/inspector`
     * * `arn:aws:securityhub:${var.region}::product/aws/macie`
     * * `arn:aws:securityhub:${var.region}::product/alertlogic/althreatmanagement`
     * * `arn:aws:securityhub:${var.region}::product/armordefense/armoranywhere`
     * * `arn:aws:securityhub:${var.region}::product/barracuda/cloudsecurityguardian`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/cloudguard-iaas`
     * * `arn:aws:securityhub:${var.region}::product/checkpoint/dome9-arc`
     * * `arn:aws:securityhub:${var.region}::product/crowdstrike/crowdstrike-falcon`
     * * `arn:aws:securityhub:${var.region}::product/cyberark/cyberark-pta`
     * * `arn:aws:securityhub:${var.region}::product/f5networks/f5-advanced-waf`
     * * `arn:aws:securityhub:${var.region}::product/fortinet/fortigate`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/aws-infection-monkey`
     * * `arn:aws:securityhub:${var.region}::product/guardicore/guardicore`
     * * `arn:aws:securityhub:${var.region}::product/ibm/qradar-siem`
     * * `arn:aws:securityhub:${var.region}::product/imperva/imperva-attack-analytics`
     * * `arn:aws:securityhub:${var.region}::product/mcafee-skyhigh/mcafee-mvision-cloud-aws`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/redlock`
     * * `arn:aws:securityhub:${var.region}::product/paloaltonetworks/vm-series`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-pc`
     * * `arn:aws:securityhub:${var.region}::product/qualys/qualys-vm`
     * * `arn:aws:securityhub:${var.region}::product/rapid7/insightvm`
     * * `arn:aws:securityhub:${var.region}::product/sophos/sophos-server-protection`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-enterprise`
     * * `arn:aws:securityhub:${var.region}::product/splunk/splunk-phantom`
     * * `arn:aws:securityhub:${var.region}::product/sumologicinc/sumologic-mda`
     * * `arn:aws:securityhub:${var.region}::product/symantec-corp/symantec-cwp`
     * * `arn:aws:securityhub:${var.region}::product/tenable/tenable-io`
     * * `arn:aws:securityhub:${var.region}::product/trend-micro/deep-security`
     * * `arn:aws:securityhub:${var.region}::product/turbot/turbot`
     * * `arn:aws:securityhub:${var.region}::product/twistlock/twistlock-enterprise`
     */
    public val productArn: Output<String>
        get() = javaResource.productArn().applyValue({ args0 -> args0 })
}

public object ProductSubscriptionMapper : ResourceMapper<ProductSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.ProductSubscription::class == javaResource::class

    override fun map(javaResource: Resource): ProductSubscription = ProductSubscription(
        javaResource
            as com.pulumi.aws.securityhub.ProductSubscription,
    )
}

/**
 * @see [ProductSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProductSubscription].
 */
public suspend fun productSubscription(
    name: String,
    block: suspend ProductSubscriptionResourceBuilder.() -> Unit,
): ProductSubscription {
    val builder = ProductSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProductSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun productSubscription(name: String): ProductSubscription {
    val builder = ProductSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
