@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [StandardsControl].
 */
@PulumiTagMarker
public class StandardsControlResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StandardsControlArgs = StandardsControlArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StandardsControlArgsBuilder.() -> Unit) {
        val builder = StandardsControlArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StandardsControl {
        val builtJavaResource = com.pulumi.aws.securityhub.StandardsControl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StandardsControl(builtJavaResource)
    }
}

/**
 * Disable/enable Security Hub standards control in the current region.
 * The `aws.securityhub.StandardsControl` behaves differently from normal resources, in that
 * Pulumi does not _create_ this resource, but instead "adopts" it
 * into management. When you _delete_ this resource configuration, Pulumi "abandons" resource as is and just removes it from the state.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.securityhub.StandardsSubscription;
 * import com.pulumi.aws.securityhub.StandardsSubscriptionArgs;
 * import com.pulumi.aws.securityhub.StandardsControl;
 * import com.pulumi.aws.securityhub.StandardsControlArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var cisAwsFoundationsBenchmark = new StandardsSubscription("cisAwsFoundationsBenchmark", StandardsSubscriptionArgs.builder()
 *             .standardsArn("arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *         var ensureIamPasswordPolicyPreventsPasswordReuse = new StandardsControl("ensureIamPasswordPolicyPreventsPasswordReuse", StandardsControlArgs.builder()
 *             .standardsControlArn("arn:aws:securityhub:us-east-1:111111111111:control/cis-aws-foundations-benchmark/v/1.2.0/1.10")
 *             .controlStatus("DISABLED")
 *             .disabledReason("We handle password policies within Okta")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(cisAwsFoundationsBenchmark)
 *                 .build());
 *     }
 * }
 * ```
 */
public class StandardsControl internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.StandardsControl,
) : KotlinCustomResource(javaResource, StandardsControlMapper) {
    /**
     * The identifier of the security standard control.
     */
    public val controlId: Output<String>
        get() = javaResource.controlId().applyValue({ args0 -> args0 })

    /**
     * The control status could be `ENABLED` or `DISABLED`. You have to specify `disabled_reason` argument for `DISABLED` control status.
     */
    public val controlStatus: Output<String>
        get() = javaResource.controlStatus().applyValue({ args0 -> args0 })

    /**
     * The date and time that the status of the security standard control was most recently updated.
     */
    public val controlStatusUpdatedAt: Output<String>
        get() = javaResource.controlStatusUpdatedAt().applyValue({ args0 -> args0 })

    /**
     * The standard control longer description. Provides information about what the control is checking for.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * A description of the reason why you are disabling a security standard control. If you specify this attribute, `control_status` will be set to `DISABLED` automatically.
     */
    public val disabledReason: Output<String>
        get() = javaResource.disabledReason().applyValue({ args0 -> args0 })

    /**
     * The list of requirements that are related to this control.
     */
    public val relatedRequirements: Output<List<String>>
        get() = javaResource.relatedRequirements().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A link to remediation information for the control in the Security Hub user documentation.
     */
    public val remediationUrl: Output<String>
        get() = javaResource.remediationUrl().applyValue({ args0 -> args0 })

    /**
     * The severity of findings generated from this security standard control.
     */
    public val severityRating: Output<String>
        get() = javaResource.severityRating().applyValue({ args0 -> args0 })

    /**
     * The standards control ARN. See the AWS documentation for how to list existing controls using [`get-enabled-standards`](https://awscli&#46;amazonaws&#46;com/v2/documentation/api/latest/reference/securityhub/get-enabled-standards&#46;html) and [`describe-standards-controls`](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/securityhub/describe-standards-controls.html).
     */
    public val standardsControlArn: Output<String>
        get() = javaResource.standardsControlArn().applyValue({ args0 -> args0 })

    /**
     * The standard control title.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })
}

public object StandardsControlMapper : ResourceMapper<StandardsControl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.StandardsControl::class == javaResource::class

    override fun map(javaResource: Resource): StandardsControl = StandardsControl(
        javaResource as
            com.pulumi.aws.securityhub.StandardsControl,
    )
}

/**
 * @see [StandardsControl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StandardsControl].
 */
public suspend fun standardsControl(
    name: String,
    block: suspend StandardsControlResourceBuilder.() -> Unit,
): StandardsControl {
    val builder = StandardsControlResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StandardsControl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun standardsControl(name: String): StandardsControl {
    val builder = StandardsControlResourceBuilder()
    builder.name(name)
    return builder.build()
}
