@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StandardsSubscription].
 */
@PulumiTagMarker
public class StandardsSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StandardsSubscriptionArgs = StandardsSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StandardsSubscriptionArgsBuilder.() -> Unit) {
        val builder = StandardsSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StandardsSubscription {
        val builtJavaResource =
            com.pulumi.aws.securityhub.StandardsSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StandardsSubscription(builtJavaResource)
    }
}

/**
 * Subscribes to a Security Hub standard.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.securityhub.Account;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.securityhub.StandardsSubscription;
 * import com.pulumi.aws.securityhub.StandardsSubscriptionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         final var current = AwsFunctions.getRegion();
 *         var cis = new StandardsSubscription("cis", StandardsSubscriptionArgs.builder()
 *             .standardsArn("arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *         var pci321 = new StandardsSubscription("pci321", StandardsSubscriptionArgs.builder()
 *             .standardsArn(String.format("arn:aws:securityhub:%s::standards/pci-dss/v/3.2.1", current.applyValue(getRegionResult -> getRegionResult.name())))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Security Hub standards subscriptions using the standards subscription ARN. For example:
 * ```sh
 *  $ pulumi import aws:securityhub/standardsSubscription:StandardsSubscription cis arn:aws:securityhub:eu-west-1:123456789012:subscription/cis-aws-foundations-benchmark/v/1.2.0
 * ```
 *  ```sh
 *  $ pulumi import aws:securityhub/standardsSubscription:StandardsSubscription pci_321 arn:aws:securityhub:eu-west-1:123456789012:subscription/pci-dss/v/3.2.1
 * ```
 *  ```sh
 *  $ pulumi import aws:securityhub/standardsSubscription:StandardsSubscription nist_800_53_rev_5 arn:aws:securityhub:eu-west-1:123456789012:subscription/nist-800-53/v/5.0.0
 * ```
 *
 */
public class StandardsSubscription internal constructor(
    override val javaResource: com.pulumi.aws.securityhub.StandardsSubscription,
) : KotlinCustomResource(javaResource, StandardsSubscriptionMapper) {
    /**
     * The ARN of a standard - see below.
     * Currently available standards (remember to replace `${var.region}` as appropriate):
     * | Name                                     | ARN                                                                                             |
     * |------------------------------------------|-------------------------------------------------------------------------------------------------|
     * | AWS Foundational Security Best Practices | `arn:aws:securityhub:${var.region}::standards/aws-foundational-security-best-practices/v/1.0.0` |
     * | CIS AWS Foundations Benchmark v1.2.0     | `arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0`                           |
     * | CIS AWS Foundations Benchmark v1.4.0     | `arn:aws:securityhub:${var.region}::standards/cis-aws-foundations-benchmark/v/1.4.0`            |
     * | NIST SP 800-53 Rev. 5                    | `arn:aws:securityhub:${var.region}::standards/nist-800-53/v/5.0.0`                              |
     * | PCI DSS                                  | `arn:aws:securityhub:${var.region}::standards/pci-dss/v/3.2.1`                                  |
     */
    public val standardsArn: Output<String>
        get() = javaResource.standardsArn().applyValue({ args0 -> args0 })
}

public object StandardsSubscriptionMapper : ResourceMapper<StandardsSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.securityhub.StandardsSubscription::class == javaResource::class

    override fun map(javaResource: Resource): StandardsSubscription =
        StandardsSubscription(javaResource as com.pulumi.aws.securityhub.StandardsSubscription)
}

/**
 * @see [StandardsSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StandardsSubscription].
 */
public suspend fun standardsSubscription(
    name: String,
    block: suspend StandardsSubscriptionResourceBuilder.() -> Unit,
): StandardsSubscription {
    val builder = StandardsSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StandardsSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun standardsSubscription(name: String): StandardsSubscription {
    val builder = StandardsSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
