@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersFindingProviderFieldsTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparison The condition to apply to a string value when querying for findings. Valid values include: `EQUALS` and `NOT_EQUALS`.
 * @property value A date range value for the date filter, provided as an Integer.
 */
public data class InsightFiltersFindingProviderFieldsTypeArgs(
    public val comparison: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersFindingProviderFieldsTypeArgs> {
    override fun toJava():
        com.pulumi.aws.securityhub.inputs.InsightFiltersFindingProviderFieldsTypeArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersFindingProviderFieldsTypeArgs.builder()
            .comparison(comparison.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersFindingProviderFieldsTypeArgs].
 */
@PulumiTagMarker
public class InsightFiltersFindingProviderFieldsTypeArgsBuilder internal constructor() {
    private var comparison: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The condition to apply to a string value when querying for findings. Valid values include: `EQUALS` and `NOT_EQUALS`.
     */
    @JvmName("tqomharrwxgfbuhl")
    public suspend fun comparison(`value`: Output<String>) {
        this.comparison = value
    }

    /**
     * @param value A date range value for the date filter, provided as an Integer.
     */
    @JvmName("wvdjdwmdmspgsmyw")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The condition to apply to a string value when querying for findings. Valid values include: `EQUALS` and `NOT_EQUALS`.
     */
    @JvmName("acoqnjcnikxnrwvu")
    public suspend fun comparison(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparison = mapped
    }

    /**
     * @param value A date range value for the date filter, provided as an Integer.
     */
    @JvmName("ashjuldweihaqbws")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): InsightFiltersFindingProviderFieldsTypeArgs =
        InsightFiltersFindingProviderFieldsTypeArgs(
            comparison = comparison ?: throw PulumiNullFieldException("comparison"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
