@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersRecordStateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparison The condition to apply to a string value when querying for findings. Valid values include: `EQUALS` and `NOT_EQUALS`.
 * @property value A date range value for the date filter, provided as an Integer.
 */
public data class InsightFiltersRecordStateArgs(
    public val comparison: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersRecordStateArgs> {
    override fun toJava(): com.pulumi.aws.securityhub.inputs.InsightFiltersRecordStateArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersRecordStateArgs.builder()
            .comparison(comparison.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersRecordStateArgs].
 */
@PulumiTagMarker
public class InsightFiltersRecordStateArgsBuilder internal constructor() {
    private var comparison: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The condition to apply to a string value when querying for findings. Valid values include: `EQUALS` and `NOT_EQUALS`.
     */
    @JvmName("kxmxwckykkplrdwn")
    public suspend fun comparison(`value`: Output<String>) {
        this.comparison = value
    }

    /**
     * @param value A date range value for the date filter, provided as an Integer.
     */
    @JvmName("idfkawnenjqojmsk")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The condition to apply to a string value when querying for findings. Valid values include: `EQUALS` and `NOT_EQUALS`.
     */
    @JvmName("xunamivkcqmtfren")
    public suspend fun comparison(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparison = mapped
    }

    /**
     * @param value A date range value for the date filter, provided as an Integer.
     */
    @JvmName("jrvdnqhldnyfngso")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): InsightFiltersRecordStateArgs = InsightFiltersRecordStateArgs(
        comparison = comparison ?: throw PulumiNullFieldException("comparison"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
