@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unit A date range unit for the date filter. Valid values: `DAYS`.
 * @property value A date range value for the date filter, provided as an Integer.
 */
public data class InsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeArgs(
    public val unit: Output<String>,
    public val `value`: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeArgs> {
    override fun toJava():
        com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeArgs.builder()
            .unit(unit.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeArgs].
 */
@PulumiTagMarker
public class InsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeArgsBuilder internal
constructor() {
    private var unit: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value A date range unit for the date filter. Valid values: `DAYS`.
     */
    @JvmName("scnnrmjjdfptldqt")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value A date range value for the date filter, provided as an Integer.
     */
    @JvmName("gchlyqdfjwgyarti")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value A date range unit for the date filter. Valid values: `DAYS`.
     */
    @JvmName("paottkxwrgvyopxm")
    public suspend fun unit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    /**
     * @param value A date range value for the date filter, provided as an Integer.
     */
    @JvmName("rwcccbxkijyggqvj")
    public suspend fun `value`(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): InsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeArgs =
        InsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeArgs(
            unit = unit ?: throw PulumiNullFieldException("unit"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
