@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dateRange A configuration block of the date range for the date filter. See date_range below for more details.
 * @property end An end date for the date filter. Required with `start` if `date_range` is not specified.
 * @property start A start date for the date filter. Required with `end` if `date_range` is not specified.
 */
public data class InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs(
    public val dateRange: Output<InsightFiltersResourceAwsIamAccessKeyCreatedAtDateRangeArgs>? = null,
    public val end: Output<String>? = null,
    public val start: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs> {
    override fun toJava():
        com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs.builder()
            .dateRange(dateRange?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .end(end?.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs].
 */
@PulumiTagMarker
public class InsightFiltersResourceAwsIamAccessKeyCreatedAtArgsBuilder internal constructor() {
    private var dateRange: Output<InsightFiltersResourceAwsIamAccessKeyCreatedAtDateRangeArgs>? = null

    private var end: Output<String>? = null

    private var start: Output<String>? = null

    /**
     * @param value A configuration block of the date range for the date filter. See date_range below for more details.
     */
    @JvmName("ldjwiahjeyinpatg")
    public suspend
    fun dateRange(`value`: Output<InsightFiltersResourceAwsIamAccessKeyCreatedAtDateRangeArgs>) {
        this.dateRange = value
    }

    /**
     * @param value An end date for the date filter. Required with `start` if `date_range` is not specified.
     */
    @JvmName("feolwtdufpfujyrj")
    public suspend fun end(`value`: Output<String>) {
        this.end = value
    }

    /**
     * @param value A start date for the date filter. Required with `end` if `date_range` is not specified.
     */
    @JvmName("mebqmsotbsblinrp")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value A configuration block of the date range for the date filter. See date_range below for more details.
     */
    @JvmName("gxlynvcxaemonefy")
    public suspend
    fun dateRange(`value`: InsightFiltersResourceAwsIamAccessKeyCreatedAtDateRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateRange = mapped
    }

    /**
     * @param argument A configuration block of the date range for the date filter. See date_range below for more details.
     */
    @JvmName("jjbpxspijgeftnov")
    public suspend
    fun dateRange(argument: suspend InsightFiltersResourceAwsIamAccessKeyCreatedAtDateRangeArgsBuilder.() -> Unit) {
        val toBeMapped =
            InsightFiltersResourceAwsIamAccessKeyCreatedAtDateRangeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dateRange = mapped
    }

    /**
     * @param value An end date for the date filter. Required with `start` if `date_range` is not specified.
     */
    @JvmName("rwwoqrylwvurqkha")
    public suspend fun end(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value A start date for the date filter. Required with `end` if `date_range` is not specified.
     */
    @JvmName("rirqtcelkxutnjhg")
    public suspend fun start(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs =
        InsightFiltersResourceAwsIamAccessKeyCreatedAtArgs(
            dateRange = dateRange,
            end = end,
            start = start,
        )
}
