@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.inputs

import com.pulumi.aws.securityhub.inputs.InsightFiltersResourceContainerLaunchedAtArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property dateRange A configuration block of the date range for the date filter. See date_range below for more details.
 * @property end An end date for the date filter. Required with `start` if `date_range` is not specified.
 * @property start A start date for the date filter. Required with `end` if `date_range` is not specified.
 */
public data class InsightFiltersResourceContainerLaunchedAtArgs(
    public val dateRange: Output<InsightFiltersResourceContainerLaunchedAtDateRangeArgs>? = null,
    public val end: Output<String>? = null,
    public val start: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.securityhub.inputs.InsightFiltersResourceContainerLaunchedAtArgs> {
    override fun toJava():
        com.pulumi.aws.securityhub.inputs.InsightFiltersResourceContainerLaunchedAtArgs =
        com.pulumi.aws.securityhub.inputs.InsightFiltersResourceContainerLaunchedAtArgs.builder()
            .dateRange(dateRange?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .end(end?.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InsightFiltersResourceContainerLaunchedAtArgs].
 */
@PulumiTagMarker
public class InsightFiltersResourceContainerLaunchedAtArgsBuilder internal constructor() {
    private var dateRange: Output<InsightFiltersResourceContainerLaunchedAtDateRangeArgs>? = null

    private var end: Output<String>? = null

    private var start: Output<String>? = null

    /**
     * @param value A configuration block of the date range for the date filter. See date_range below for more details.
     */
    @JvmName("jomlemlnkwwnffkg")
    public suspend
    fun dateRange(`value`: Output<InsightFiltersResourceContainerLaunchedAtDateRangeArgs>) {
        this.dateRange = value
    }

    /**
     * @param value An end date for the date filter. Required with `start` if `date_range` is not specified.
     */
    @JvmName("dutqixefapunevgt")
    public suspend fun end(`value`: Output<String>) {
        this.end = value
    }

    /**
     * @param value A start date for the date filter. Required with `end` if `date_range` is not specified.
     */
    @JvmName("ugwoxmquvlnywfnl")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value A configuration block of the date range for the date filter. See date_range below for more details.
     */
    @JvmName("uwmpgvoyfyvcjikt")
    public suspend fun dateRange(`value`: InsightFiltersResourceContainerLaunchedAtDateRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateRange = mapped
    }

    /**
     * @param argument A configuration block of the date range for the date filter. See date_range below for more details.
     */
    @JvmName("yotjnvamvknqfiye")
    public suspend
    fun dateRange(argument: suspend InsightFiltersResourceContainerLaunchedAtDateRangeArgsBuilder.() -> Unit) {
        val toBeMapped = InsightFiltersResourceContainerLaunchedAtDateRangeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dateRange = mapped
    }

    /**
     * @param value An end date for the date filter. Required with `start` if `date_range` is not specified.
     */
    @JvmName("mqhybngiusotyyfb")
    public suspend fun end(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value A start date for the date filter. Required with `end` if `date_range` is not specified.
     */
    @JvmName("wcwfxsmvlqlennkm")
    public suspend fun start(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): InsightFiltersResourceContainerLaunchedAtArgs =
        InsightFiltersResourceContainerLaunchedAtArgs(
            dateRange = dateRange,
            end = end,
            start = start,
        )
}
