@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property awsAccountIds AWS account ID that a finding is generated in. See String_Filter below for more details.
 * @property companyNames The name of the findings provider (company) that owns the solution (product) that generates findings. See String_Filter below for more details.
 * @property complianceStatuses Exclusive to findings that are generated as the result of a check run against a specific rule in a supported standard, such as CIS AWS Foundations. Contains security standard-related finding details. See String Filter below for more details.
 * @property confidences A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
 * @property createdAts An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security issue that a finding captured. See Date Filter below for more details.
 * @property criticalities The level of importance assigned to the resources associated with the finding. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
 * @property descriptions A finding's description. See String Filter below for more details.
 * @property findingProviderFieldsConfidences The finding provider value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. See Number Filter below for more details.
 * @property findingProviderFieldsCriticalities The finding provider value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. See Number Filter below for more details.
 * @property findingProviderFieldsRelatedFindingsIds The finding identifier of a related finding that is identified by the finding provider. See String Filter below for more details.
 * @property findingProviderFieldsRelatedFindingsProductArns The ARN of the solution that generated a related finding that is identified by the finding provider. See String Filter below for more details.
 * @property findingProviderFieldsSeverityLabels The finding provider value for the severity label. See String Filter below for more details.
 * @property findingProviderFieldsSeverityOriginals The finding provider's original value for the severity. See String Filter below for more details.
 * @property findingProviderFieldsTypes One or more finding types that the finding provider assigned to the finding. Uses the format of `namespace/category/classifier` that classify a finding. Valid namespace values include: `Software and Configuration Checks`, `TTPs`, `Effects`, `Unusual Behaviors`, and `Sensitive Data Identifications`. See String Filter below for more details.
 * @property firstObservedAts An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential security issue that a finding captured. See Date Filter below for more details.
 * @property generatorIds The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. See String Filter below for more details.
 * @property ids The security findings provider-specific identifier for a finding. See String Filter below for more details.
 * @property keywords A keyword for a finding. See Keyword Filter below for more details.
 * @property lastObservedAts An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the potential security issue that a finding captured. See Date Filter below for more details.
 * @property malwareNames The name of the malware that was observed. See String Filter below for more details.
 * @property malwarePaths The filesystem path of the malware that was observed. See String Filter below for more details.
 * @property malwareStates The state of the malware that was observed. See String Filter below for more details.
 * @property malwareTypes The type of the malware that was observed. See String Filter below for more details.
 * @property networkDestinationDomains The destination domain of network-related information about a finding. See String Filter below for more details.
 * @property networkDestinationIpv4s The destination IPv4 address of network-related information about a finding. See Ip Filter below for more details.
 * @property networkDestinationIpv6s The destination IPv6 address of network-related information about a finding. See Ip Filter below for more details.
 * @property networkDestinationPorts The destination port of network-related information about a finding. See Number Filter below for more details.
 * @property networkDirections Indicates the direction of network traffic associated with a finding. See String Filter below for more details.
 * @property networkProtocols The protocol of network-related information about a finding. See String Filter below for more details.
 * @property networkSourceDomains The source domain of network-related information about a finding. See String Filter below for more details.
 * @property networkSourceIpv4s The source IPv4 address of network-related information about a finding. See Ip Filter below for more details.
 * @property networkSourceIpv6s The source IPv6 address of network-related information about a finding. See Ip Filter below for more details.
 * @property networkSourceMacs The source media access control (MAC) address of network-related information about a finding. See String Filter below for more details.
 * @property networkSourcePorts The source port of network-related information about a finding. See Number Filter below for more details.
 * @property noteTexts The text of a note. See String Filter below for more details.
 * @property noteUpdatedAts The timestamp of when the note was updated. See Date Filter below for more details.
 * @property noteUpdatedBies The principal that created a note. See String Filter below for more details.
 * @property processLaunchedAts The date/time that the process was launched. See Date Filter below for more details.
 * @property processNames The name of the process. See String Filter below for more details.
 * @property processParentPids The parent process ID. See Number Filter below for more details.
 * @property processPaths The path to the process executable. See String Filter below for more details.
 * @property processPids The process ID. See Number Filter below for more details.
 * @property processTerminatedAts The date/time that the process was terminated. See Date Filter below for more details.
 * @property productArns The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider) after this provider's product (solution that generates findings) is registered with Security Hub. See String Filter below for more details.
 * @property productFields A data type where security-findings providers can include additional solution-specific details that aren't part of the defined `AwsSecurityFinding` format. See Map Filter below for more details.
 * @property productNames The name of the solution (product) that generates findings. See String Filter below for more details.
 * @property recommendationTexts The recommendation of what to do about the issue described in a finding. See String Filter below for more details.
 * @property recordStates The updated record state for the finding. See String Filter below for more details.
 * @property relatedFindingsIds The solution-generated identifier for a related finding. See String Filter below for more details.
 * @property relatedFindingsProductArns The ARN of the solution that generated a related finding. See String Filter below for more details.
 * @property resourceAwsEc2InstanceIamInstanceProfileArns The IAM profile ARN of the instance. See String Filter below for more details.
 * @property resourceAwsEc2InstanceImageIds The Amazon Machine Image (AMI) ID of the instance. See String Filter below for more details.
 * @property resourceAwsEc2InstanceIpv4Addresses The IPv4 addresses associated with the instance. See Ip Filter below for more details.
 * @property resourceAwsEc2InstanceIpv6Addresses The IPv6 addresses associated with the instance. See Ip Filter below for more details.
 * @property resourceAwsEc2InstanceKeyNames The key name associated with the instance. See String Filter below for more details.
 * @property resourceAwsEc2InstanceLaunchedAts The date and time the instance was launched. See Date Filter below for more details.
 * @property resourceAwsEc2InstanceSubnetIds The identifier of the subnet that the instance was launched in. See String Filter below for more details.
 * @property resourceAwsEc2InstanceTypes The instance type of the instance. See String Filter below for more details.
 * @property resourceAwsEc2InstanceVpcIds The identifier of the VPC that the instance was launched in. See String Filter below for more details.
 * @property resourceAwsIamAccessKeyCreatedAts The creation date/time of the IAM access key related to a finding. See Date Filter below for more details.
 * @property resourceAwsIamAccessKeyStatuses The status of the IAM access key related to a finding. See String Filter below for more details.
 * @property resourceAwsIamAccessKeyUserNames The user associated with the IAM access key related to a finding. See String Filter below for more details.
 * @property resourceAwsS3BucketOwnerIds The canonical user ID of the owner of the S3 bucket. See String Filter below for more details.
 * @property resourceAwsS3BucketOwnerNames The display name of the owner of the S3 bucket. See String Filter below for more details.
 * @property resourceContainerImageIds The identifier of the image related to a finding. See String Filter below for more details.
 * @property resourceContainerImageNames The name of the image related to a finding. See String Filter below for more details.
 * @property resourceContainerLaunchedAts The date/time that the container was started. See Date Filter below for more details.
 * @property resourceContainerNames The name of the container related to a finding. See String Filter below for more details.
 * @property resourceDetailsOthers The details of a resource that doesn't have a specific subfield for the resource type defined. See Map Filter below for more details.
 * @property resourceIds The canonical identifier for the given resource type. See String Filter below for more details.
 * @property resourcePartitions The canonical AWS partition name that the Region is assigned to. See String Filter below for more details.
 * @property resourceRegions The canonical AWS external Region name where this resource is located. See String Filter below for more details.
 * @property resourceTags A list of AWS tags associated with a resource at the time the finding was processed. See Map Filter below for more details.
 * @property resourceTypes Specifies the type of the resource that details are provided for. See String Filter below for more details.
 * @property severityLabels The label of a finding's severity. See String Filter below for more details.
 * @property sourceUrls A URL that links to a page about the current finding in the security-findings provider's solution. See String Filter below for more details.
 * @property threatIntelIndicatorCategories The category of a threat intelligence indicator. See String Filter below for more details.
 * @property threatIntelIndicatorLastObservedAts The date/time of the last observation of a threat intelligence indicator. See Date Filter below for more details.
 * @property threatIntelIndicatorSourceUrls The URL for more details from the source of the threat intelligence. See String Filter below for more details.
 * @property threatIntelIndicatorSources The source of the threat intelligence. See String Filter below for more details.
 * @property threatIntelIndicatorTypes The type of a threat intelligence indicator. See String Filter below for more details.
 * @property threatIntelIndicatorValues The value of a threat intelligence indicator. See String Filter below for more details.
 * @property titles A finding's title. See String Filter below for more details.
 * @property types A finding type in the format of `namespace/category/classifier` that classifies a finding. See String Filter below for more details.
 * @property updatedAts An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding record. See Date Filter below for more details.
 * @property userDefinedValues A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. See Map Filter below for more details.
 * @property verificationStates The veracity of a finding. See String Filter below for more details.
 * @property workflowStatuses The status of the investigation into a finding. See Workflow Status Filter below for more details.
 */
public data class InsightFilters(
    public val awsAccountIds: List<InsightFiltersAwsAccountId>? = null,
    public val companyNames: List<InsightFiltersCompanyName>? = null,
    public val complianceStatuses: List<InsightFiltersComplianceStatus>? = null,
    public val confidences: List<InsightFiltersConfidence>? = null,
    public val createdAts: List<InsightFiltersCreatedAt>? = null,
    public val criticalities: List<InsightFiltersCriticality>? = null,
    public val descriptions: List<InsightFiltersDescription>? = null,
    public val findingProviderFieldsConfidences: List<InsightFiltersFindingProviderFieldsConfidence>? =
        null,
    public val findingProviderFieldsCriticalities:
    List<InsightFiltersFindingProviderFieldsCriticality>? = null,
    public val findingProviderFieldsRelatedFindingsIds:
    List<InsightFiltersFindingProviderFieldsRelatedFindingsId>? = null,
    public val findingProviderFieldsRelatedFindingsProductArns:
    List<InsightFiltersFindingProviderFieldsRelatedFindingsProductArn>? = null,
    public val findingProviderFieldsSeverityLabels:
    List<InsightFiltersFindingProviderFieldsSeverityLabel>? = null,
    public val findingProviderFieldsSeverityOriginals:
    List<InsightFiltersFindingProviderFieldsSeverityOriginal>? = null,
    public val findingProviderFieldsTypes: List<InsightFiltersFindingProviderFieldsType>? = null,
    public val firstObservedAts: List<InsightFiltersFirstObservedAt>? = null,
    public val generatorIds: List<InsightFiltersGeneratorId>? = null,
    public val ids: List<InsightFiltersId>? = null,
    public val keywords: List<InsightFiltersKeyword>? = null,
    public val lastObservedAts: List<InsightFiltersLastObservedAt>? = null,
    public val malwareNames: List<InsightFiltersMalwareName>? = null,
    public val malwarePaths: List<InsightFiltersMalwarePath>? = null,
    public val malwareStates: List<InsightFiltersMalwareState>? = null,
    public val malwareTypes: List<InsightFiltersMalwareType>? = null,
    public val networkDestinationDomains: List<InsightFiltersNetworkDestinationDomain>? = null,
    public val networkDestinationIpv4s: List<InsightFiltersNetworkDestinationIpv4>? = null,
    public val networkDestinationIpv6s: List<InsightFiltersNetworkDestinationIpv6>? = null,
    public val networkDestinationPorts: List<InsightFiltersNetworkDestinationPort>? = null,
    public val networkDirections: List<InsightFiltersNetworkDirection>? = null,
    public val networkProtocols: List<InsightFiltersNetworkProtocol>? = null,
    public val networkSourceDomains: List<InsightFiltersNetworkSourceDomain>? = null,
    public val networkSourceIpv4s: List<InsightFiltersNetworkSourceIpv4>? = null,
    public val networkSourceIpv6s: List<InsightFiltersNetworkSourceIpv6>? = null,
    public val networkSourceMacs: List<InsightFiltersNetworkSourceMac>? = null,
    public val networkSourcePorts: List<InsightFiltersNetworkSourcePort>? = null,
    public val noteTexts: List<InsightFiltersNoteText>? = null,
    public val noteUpdatedAts: List<InsightFiltersNoteUpdatedAt>? = null,
    public val noteUpdatedBies: List<InsightFiltersNoteUpdatedBy>? = null,
    public val processLaunchedAts: List<InsightFiltersProcessLaunchedAt>? = null,
    public val processNames: List<InsightFiltersProcessName>? = null,
    public val processParentPids: List<InsightFiltersProcessParentPid>? = null,
    public val processPaths: List<InsightFiltersProcessPath>? = null,
    public val processPids: List<InsightFiltersProcessPid>? = null,
    public val processTerminatedAts: List<InsightFiltersProcessTerminatedAt>? = null,
    public val productArns: List<InsightFiltersProductArn>? = null,
    public val productFields: List<InsightFiltersProductField>? = null,
    public val productNames: List<InsightFiltersProductName>? = null,
    public val recommendationTexts: List<InsightFiltersRecommendationText>? = null,
    public val recordStates: List<InsightFiltersRecordState>? = null,
    public val relatedFindingsIds: List<InsightFiltersRelatedFindingsId>? = null,
    public val relatedFindingsProductArns: List<InsightFiltersRelatedFindingsProductArn>? = null,
    public val resourceAwsEc2InstanceIamInstanceProfileArns:
    List<InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArn>? = null,
    public val resourceAwsEc2InstanceImageIds: List<InsightFiltersResourceAwsEc2InstanceImageId>? =
        null,
    public val resourceAwsEc2InstanceIpv4Addresses:
    List<InsightFiltersResourceAwsEc2InstanceIpv4Address>? = null,
    public val resourceAwsEc2InstanceIpv6Addresses:
    List<InsightFiltersResourceAwsEc2InstanceIpv6Address>? = null,
    public val resourceAwsEc2InstanceKeyNames: List<InsightFiltersResourceAwsEc2InstanceKeyName>? =
        null,
    public val resourceAwsEc2InstanceLaunchedAts:
    List<InsightFiltersResourceAwsEc2InstanceLaunchedAt>? = null,
    public val resourceAwsEc2InstanceSubnetIds: List<InsightFiltersResourceAwsEc2InstanceSubnetId>? =
        null,
    public val resourceAwsEc2InstanceTypes: List<InsightFiltersResourceAwsEc2InstanceType>? = null,
    public val resourceAwsEc2InstanceVpcIds: List<InsightFiltersResourceAwsEc2InstanceVpcId>? = null,
    public val resourceAwsIamAccessKeyCreatedAts:
    List<InsightFiltersResourceAwsIamAccessKeyCreatedAt>? = null,
    public val resourceAwsIamAccessKeyStatuses: List<InsightFiltersResourceAwsIamAccessKeyStatus>? =
        null,
    public val resourceAwsIamAccessKeyUserNames: List<InsightFiltersResourceAwsIamAccessKeyUserName>? =
        null,
    public val resourceAwsS3BucketOwnerIds: List<InsightFiltersResourceAwsS3BucketOwnerId>? = null,
    public val resourceAwsS3BucketOwnerNames: List<InsightFiltersResourceAwsS3BucketOwnerName>? =
        null,
    public val resourceContainerImageIds: List<InsightFiltersResourceContainerImageId>? = null,
    public val resourceContainerImageNames: List<InsightFiltersResourceContainerImageName>? = null,
    public val resourceContainerLaunchedAts: List<InsightFiltersResourceContainerLaunchedAt>? = null,
    public val resourceContainerNames: List<InsightFiltersResourceContainerName>? = null,
    public val resourceDetailsOthers: List<InsightFiltersResourceDetailsOther>? = null,
    public val resourceIds: List<InsightFiltersResourceId>? = null,
    public val resourcePartitions: List<InsightFiltersResourcePartition>? = null,
    public val resourceRegions: List<InsightFiltersResourceRegion>? = null,
    public val resourceTags: List<InsightFiltersResourceTag>? = null,
    public val resourceTypes: List<InsightFiltersResourceType>? = null,
    public val severityLabels: List<InsightFiltersSeverityLabel>? = null,
    public val sourceUrls: List<InsightFiltersSourceUrl>? = null,
    public val threatIntelIndicatorCategories: List<InsightFiltersThreatIntelIndicatorCategory>? =
        null,
    public val threatIntelIndicatorLastObservedAts:
    List<InsightFiltersThreatIntelIndicatorLastObservedAt>? = null,
    public val threatIntelIndicatorSourceUrls: List<InsightFiltersThreatIntelIndicatorSourceUrl>? =
        null,
    public val threatIntelIndicatorSources: List<InsightFiltersThreatIntelIndicatorSource>? = null,
    public val threatIntelIndicatorTypes: List<InsightFiltersThreatIntelIndicatorType>? = null,
    public val threatIntelIndicatorValues: List<InsightFiltersThreatIntelIndicatorValue>? = null,
    public val titles: List<InsightFiltersTitle>? = null,
    public val types: List<InsightFiltersType>? = null,
    public val updatedAts: List<InsightFiltersUpdatedAt>? = null,
    public val userDefinedValues: List<InsightFiltersUserDefinedValue>? = null,
    public val verificationStates: List<InsightFiltersVerificationState>? = null,
    public val workflowStatuses: List<InsightFiltersWorkflowStatus>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.InsightFilters): InsightFilters =
            InsightFilters(
                awsAccountIds = javaType.awsAccountIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersAwsAccountId.Companion.toKotlin(args0)
                    })
                }),
                companyNames = javaType.companyNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersCompanyName.Companion.toKotlin(args0)
                    })
                }),
                complianceStatuses = javaType.complianceStatuses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersComplianceStatus.Companion.toKotlin(args0)
                    })
                }),
                confidences = javaType.confidences().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersConfidence.Companion.toKotlin(args0)
                    })
                }),
                createdAts = javaType.createdAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersCreatedAt.Companion.toKotlin(args0)
                    })
                }),
                criticalities = javaType.criticalities().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersCriticality.Companion.toKotlin(args0)
                    })
                }),
                descriptions = javaType.descriptions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersDescription.Companion.toKotlin(args0)
                    })
                }),
                findingProviderFieldsConfidences = javaType.findingProviderFieldsConfidences().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersFindingProviderFieldsConfidence.Companion.toKotlin(args0)
                    })
                }),
                findingProviderFieldsCriticalities = javaType.findingProviderFieldsCriticalities().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersFindingProviderFieldsCriticality.Companion.toKotlin(args0)
                    })
                }),
                findingProviderFieldsRelatedFindingsIds = javaType.findingProviderFieldsRelatedFindingsIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersFindingProviderFieldsRelatedFindingsId.Companion.toKotlin(args0)
                    })
                }),
                findingProviderFieldsRelatedFindingsProductArns = javaType.findingProviderFieldsRelatedFindingsProductArns().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersFindingProviderFieldsRelatedFindingsProductArn.Companion.toKotlin(args0)
                    })
                }),
                findingProviderFieldsSeverityLabels = javaType.findingProviderFieldsSeverityLabels().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersFindingProviderFieldsSeverityLabel.Companion.toKotlin(args0)
                    })
                }),
                findingProviderFieldsSeverityOriginals = javaType.findingProviderFieldsSeverityOriginals().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersFindingProviderFieldsSeverityOriginal.Companion.toKotlin(args0)
                    })
                }),
                findingProviderFieldsTypes = javaType.findingProviderFieldsTypes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersFindingProviderFieldsType.Companion.toKotlin(args0)
                    })
                }),
                firstObservedAts = javaType.firstObservedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersFirstObservedAt.Companion.toKotlin(args0)
                    })
                }),
                generatorIds = javaType.generatorIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersGeneratorId.Companion.toKotlin(args0)
                    })
                }),
                ids = javaType.ids().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersId.Companion.toKotlin(args0)
                    })
                }),
                keywords = javaType.keywords().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersKeyword.Companion.toKotlin(args0)
                    })
                }),
                lastObservedAts = javaType.lastObservedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersLastObservedAt.Companion.toKotlin(args0)
                    })
                }),
                malwareNames = javaType.malwareNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersMalwareName.Companion.toKotlin(args0)
                    })
                }),
                malwarePaths = javaType.malwarePaths().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersMalwarePath.Companion.toKotlin(args0)
                    })
                }),
                malwareStates = javaType.malwareStates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersMalwareState.Companion.toKotlin(args0)
                    })
                }),
                malwareTypes = javaType.malwareTypes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersMalwareType.Companion.toKotlin(args0)
                    })
                }),
                networkDestinationDomains = javaType.networkDestinationDomains().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkDestinationDomain.Companion.toKotlin(args0)
                    })
                }),
                networkDestinationIpv4s = javaType.networkDestinationIpv4s().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkDestinationIpv4.Companion.toKotlin(args0)
                    })
                }),
                networkDestinationIpv6s = javaType.networkDestinationIpv6s().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkDestinationIpv6.Companion.toKotlin(args0)
                    })
                }),
                networkDestinationPorts = javaType.networkDestinationPorts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkDestinationPort.Companion.toKotlin(args0)
                    })
                }),
                networkDirections = javaType.networkDirections().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkDirection.Companion.toKotlin(args0)
                    })
                }),
                networkProtocols = javaType.networkProtocols().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkProtocol.Companion.toKotlin(args0)
                    })
                }),
                networkSourceDomains = javaType.networkSourceDomains().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkSourceDomain.Companion.toKotlin(args0)
                    })
                }),
                networkSourceIpv4s = javaType.networkSourceIpv4s().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkSourceIpv4.Companion.toKotlin(args0)
                    })
                }),
                networkSourceIpv6s = javaType.networkSourceIpv6s().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkSourceIpv6.Companion.toKotlin(args0)
                    })
                }),
                networkSourceMacs = javaType.networkSourceMacs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkSourceMac.Companion.toKotlin(args0)
                    })
                }),
                networkSourcePorts = javaType.networkSourcePorts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNetworkSourcePort.Companion.toKotlin(args0)
                    })
                }),
                noteTexts = javaType.noteTexts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNoteText.Companion.toKotlin(args0)
                    })
                }),
                noteUpdatedAts = javaType.noteUpdatedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNoteUpdatedAt.Companion.toKotlin(args0)
                    })
                }),
                noteUpdatedBies = javaType.noteUpdatedBies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersNoteUpdatedBy.Companion.toKotlin(args0)
                    })
                }),
                processLaunchedAts = javaType.processLaunchedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersProcessLaunchedAt.Companion.toKotlin(args0)
                    })
                }),
                processNames = javaType.processNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersProcessName.Companion.toKotlin(args0)
                    })
                }),
                processParentPids = javaType.processParentPids().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersProcessParentPid.Companion.toKotlin(args0)
                    })
                }),
                processPaths = javaType.processPaths().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersProcessPath.Companion.toKotlin(args0)
                    })
                }),
                processPids = javaType.processPids().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersProcessPid.Companion.toKotlin(args0)
                    })
                }),
                processTerminatedAts = javaType.processTerminatedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersProcessTerminatedAt.Companion.toKotlin(args0)
                    })
                }),
                productArns = javaType.productArns().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersProductArn.Companion.toKotlin(args0)
                    })
                }),
                productFields = javaType.productFields().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersProductField.Companion.toKotlin(args0)
                    })
                }),
                productNames = javaType.productNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersProductName.Companion.toKotlin(args0)
                    })
                }),
                recommendationTexts = javaType.recommendationTexts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersRecommendationText.Companion.toKotlin(args0)
                    })
                }),
                recordStates = javaType.recordStates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersRecordState.Companion.toKotlin(args0)
                    })
                }),
                relatedFindingsIds = javaType.relatedFindingsIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersRelatedFindingsId.Companion.toKotlin(args0)
                    })
                }),
                relatedFindingsProductArns = javaType.relatedFindingsProductArns().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersRelatedFindingsProductArn.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsEc2InstanceIamInstanceProfileArns = javaType.resourceAwsEc2InstanceIamInstanceProfileArns().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsEc2InstanceIamInstanceProfileArn.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsEc2InstanceImageIds = javaType.resourceAwsEc2InstanceImageIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsEc2InstanceImageId.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsEc2InstanceIpv4Addresses = javaType.resourceAwsEc2InstanceIpv4Addresses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsEc2InstanceIpv4Address.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsEc2InstanceIpv6Addresses = javaType.resourceAwsEc2InstanceIpv6Addresses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsEc2InstanceIpv6Address.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsEc2InstanceKeyNames = javaType.resourceAwsEc2InstanceKeyNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsEc2InstanceKeyName.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsEc2InstanceLaunchedAts = javaType.resourceAwsEc2InstanceLaunchedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsEc2InstanceLaunchedAt.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsEc2InstanceSubnetIds = javaType.resourceAwsEc2InstanceSubnetIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsEc2InstanceSubnetId.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsEc2InstanceTypes = javaType.resourceAwsEc2InstanceTypes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsEc2InstanceType.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsEc2InstanceVpcIds = javaType.resourceAwsEc2InstanceVpcIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsEc2InstanceVpcId.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsIamAccessKeyCreatedAts = javaType.resourceAwsIamAccessKeyCreatedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsIamAccessKeyCreatedAt.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsIamAccessKeyStatuses = javaType.resourceAwsIamAccessKeyStatuses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsIamAccessKeyStatus.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsIamAccessKeyUserNames = javaType.resourceAwsIamAccessKeyUserNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsIamAccessKeyUserName.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsS3BucketOwnerIds = javaType.resourceAwsS3BucketOwnerIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsS3BucketOwnerId.Companion.toKotlin(args0)
                    })
                }),
                resourceAwsS3BucketOwnerNames = javaType.resourceAwsS3BucketOwnerNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceAwsS3BucketOwnerName.Companion.toKotlin(args0)
                    })
                }),
                resourceContainerImageIds = javaType.resourceContainerImageIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceContainerImageId.Companion.toKotlin(args0)
                    })
                }),
                resourceContainerImageNames = javaType.resourceContainerImageNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceContainerImageName.Companion.toKotlin(args0)
                    })
                }),
                resourceContainerLaunchedAts = javaType.resourceContainerLaunchedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceContainerLaunchedAt.Companion.toKotlin(args0)
                    })
                }),
                resourceContainerNames = javaType.resourceContainerNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceContainerName.Companion.toKotlin(args0)
                    })
                }),
                resourceDetailsOthers = javaType.resourceDetailsOthers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceDetailsOther.Companion.toKotlin(args0)
                    })
                }),
                resourceIds = javaType.resourceIds().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceId.Companion.toKotlin(args0)
                    })
                }),
                resourcePartitions = javaType.resourcePartitions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourcePartition.Companion.toKotlin(args0)
                    })
                }),
                resourceRegions = javaType.resourceRegions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceRegion.Companion.toKotlin(args0)
                    })
                }),
                resourceTags = javaType.resourceTags().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceTag.Companion.toKotlin(args0)
                    })
                }),
                resourceTypes = javaType.resourceTypes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersResourceType.Companion.toKotlin(args0)
                    })
                }),
                severityLabels = javaType.severityLabels().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersSeverityLabel.Companion.toKotlin(args0)
                    })
                }),
                sourceUrls = javaType.sourceUrls().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersSourceUrl.Companion.toKotlin(args0)
                    })
                }),
                threatIntelIndicatorCategories = javaType.threatIntelIndicatorCategories().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersThreatIntelIndicatorCategory.Companion.toKotlin(args0)
                    })
                }),
                threatIntelIndicatorLastObservedAts = javaType.threatIntelIndicatorLastObservedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersThreatIntelIndicatorLastObservedAt.Companion.toKotlin(args0)
                    })
                }),
                threatIntelIndicatorSourceUrls = javaType.threatIntelIndicatorSourceUrls().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersThreatIntelIndicatorSourceUrl.Companion.toKotlin(args0)
                    })
                }),
                threatIntelIndicatorSources = javaType.threatIntelIndicatorSources().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersThreatIntelIndicatorSource.Companion.toKotlin(args0)
                    })
                }),
                threatIntelIndicatorTypes = javaType.threatIntelIndicatorTypes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersThreatIntelIndicatorType.Companion.toKotlin(args0)
                    })
                }),
                threatIntelIndicatorValues = javaType.threatIntelIndicatorValues().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersThreatIntelIndicatorValue.Companion.toKotlin(args0)
                    })
                }),
                titles = javaType.titles().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersTitle.Companion.toKotlin(args0)
                    })
                }),
                types = javaType.types().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersType.Companion.toKotlin(args0)
                    })
                }),
                updatedAts = javaType.updatedAts().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersUpdatedAt.Companion.toKotlin(args0)
                    })
                }),
                userDefinedValues = javaType.userDefinedValues().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersUserDefinedValue.Companion.toKotlin(args0)
                    })
                }),
                verificationStates = javaType.verificationStates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersVerificationState.Companion.toKotlin(args0)
                    })
                }),
                workflowStatuses = javaType.workflowStatuses().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.securityhub.kotlin.outputs.InsightFiltersWorkflowStatus.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
