@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.securityhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comparison The condition to apply to a string value when querying for findings. Valid values include: `EQUALS` and `NOT_EQUALS`.
 * @property key The key of the map filter. For example, for `ResourceTags`, `Key` identifies the name of the tag. For `UserDefinedFields`, `Key` is the name of the field.
 * @property value A date range value for the date filter, provided as an Integer.
 */
public data class InsightFiltersResourceTag(
    public val comparison: String,
    public val key: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.securityhub.outputs.InsightFiltersResourceTag):
            InsightFiltersResourceTag = InsightFiltersResourceTag(
            comparison = javaType.comparison(),
            key = javaType.key(),
            `value` = javaType.`value`(),
        )
    }
}
