@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.serverlessrepository.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [CloudFormationStack].
 */
@PulumiTagMarker
public class CloudFormationStackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CloudFormationStackArgs = CloudFormationStackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CloudFormationStackArgsBuilder.() -> Unit) {
        val builder = CloudFormationStackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CloudFormationStack {
        val builtJavaResource =
            com.pulumi.aws.serverlessrepository.CloudFormationStack(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CloudFormationStack(builtJavaResource)
    }
}

/**
 * Deploys an Application CloudFormation Stack from the Serverless Application Repository.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.serverlessrepository.CloudFormationStack;
 * import com.pulumi.aws.serverlessrepository.CloudFormationStackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentPartition = AwsFunctions.getPartition();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         var postgres_rotator = new CloudFormationStack("postgres-rotator", CloudFormationStackArgs.builder()
 *             .applicationId("arn:aws:serverlessrepo:us-east-1:297356227824:applications/SecretsManagerRDSPostgreSQLRotationSingleUser")
 *             .capabilities(
 *                 "CAPABILITY_IAM",
 *                 "CAPABILITY_RESOURCE_POLICY")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("endpoint", String.format("secretsmanager.%s.%s", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentPartition.applyValue(getPartitionResult -> getPartitionResult.dnsSuffix()))),
 *                 Map.entry("functionName", "func-postgres-rotator")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Serverless Application Repository Stack using the CloudFormation Stack name (with or without the `serverlessrepo-` prefix) or the CloudFormation Stack ID. For example:
 * ```sh
 *  $ pulumi import aws:serverlessrepository/cloudFormationStack:CloudFormationStack example serverlessrepo-postgres-rotator
 * ```
 *
 */
public class CloudFormationStack internal constructor(
    override val javaResource: com.pulumi.aws.serverlessrepository.CloudFormationStack,
) : KotlinCustomResource(javaResource, CloudFormationStackMapper) {
    /**
     * The ARN of the application from the Serverless Application Repository.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
     */
    public val capabilities: Output<List<String>>
        get() = javaResource.capabilities().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the stack to create. The resource deployed in AWS will be prefixed with `serverlessrepo-`
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of outputs from the stack.
     */
    public val outputs: Output<Map<String, String>>
        get() = javaResource.outputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A map of Parameter structures that specify input parameters for the stack.
     */
    public val parameters: Output<Map<String, String>>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The version of the application to deploy. If not supplied, deploys the latest version.
     */
    public val semanticVersion: Output<String>
        get() = javaResource.semanticVersion().applyValue({ args0 -> args0 })

    /**
     * A list of tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CloudFormationStackMapper : ResourceMapper<CloudFormationStack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.serverlessrepository.CloudFormationStack::class == javaResource::class

    override fun map(javaResource: Resource): CloudFormationStack = CloudFormationStack(
        javaResource
            as com.pulumi.aws.serverlessrepository.CloudFormationStack,
    )
}

/**
 * @see [CloudFormationStack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CloudFormationStack].
 */
public suspend fun cloudFormationStack(
    name: String,
    block: suspend CloudFormationStackResourceBuilder.() -> Unit,
): CloudFormationStack {
    val builder = CloudFormationStackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CloudFormationStack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cloudFormationStack(name: String): CloudFormationStack {
    val builder = CloudFormationStackResourceBuilder()
    builder.name(name)
    return builder.build()
}
