@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.serverlessrepository.kotlin

import com.pulumi.aws.serverlessrepository.CloudFormationStackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Deploys an Application CloudFormation Stack from the Serverless Application Repository.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetPartitionArgs;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.serverlessrepository.CloudFormationStack;
 * import com.pulumi.aws.serverlessrepository.CloudFormationStackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var currentPartition = AwsFunctions.getPartition();
 *         final var currentRegion = AwsFunctions.getRegion();
 *         var postgres_rotator = new CloudFormationStack("postgres-rotator", CloudFormationStackArgs.builder()
 *             .applicationId("arn:aws:serverlessrepo:us-east-1:297356227824:applications/SecretsManagerRDSPostgreSQLRotationSingleUser")
 *             .capabilities(
 *                 "CAPABILITY_IAM",
 *                 "CAPABILITY_RESOURCE_POLICY")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("endpoint", String.format("secretsmanager.%s.%s", currentRegion.applyValue(getRegionResult -> getRegionResult.name()),currentPartition.applyValue(getPartitionResult -> getPartitionResult.dnsSuffix()))),
 *                 Map.entry("functionName", "func-postgres-rotator")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Serverless Application Repository Stack using the CloudFormation Stack name (with or without the `serverlessrepo-` prefix) or the CloudFormation Stack ID. For example:
 * ```sh
 *  $ pulumi import aws:serverlessrepository/cloudFormationStack:CloudFormationStack example serverlessrepo-postgres-rotator
 * ```
 * @property applicationId The ARN of the application from the Serverless Application Repository.
 * @property capabilities A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
 * @property name The name of the stack to create. The resource deployed in AWS will be prefixed with `serverlessrepo-`
 * @property parameters A map of Parameter structures that specify input parameters for the stack.
 * @property semanticVersion The version of the application to deploy. If not supplied, deploys the latest version.
 * @property tags A list of tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CloudFormationStackArgs(
    public val applicationId: Output<String>? = null,
    public val capabilities: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val semanticVersion: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.serverlessrepository.CloudFormationStackArgs> {
    override fun toJava(): com.pulumi.aws.serverlessrepository.CloudFormationStackArgs =
        com.pulumi.aws.serverlessrepository.CloudFormationStackArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .capabilities(capabilities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .semanticVersion(semanticVersion?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CloudFormationStackArgs].
 */
@PulumiTagMarker
public class CloudFormationStackArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var capabilities: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var semanticVersion: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ARN of the application from the Serverless Application Repository.
     */
    @JvmName("cgpccnwmdyjuhood")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("ftsumfqqgecxabur")
    public suspend fun capabilities(`value`: Output<List<String>>) {
        this.capabilities = value
    }

    @JvmName("weacfwasdnuhfbvf")
    public suspend fun capabilities(vararg values: Output<String>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("lxgvjfkebevtvvxu")
    public suspend fun capabilities(values: List<Output<String>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value The name of the stack to create. The resource deployed in AWS will be prefixed with `serverlessrepo-`
     */
    @JvmName("bfaqiqoplpdataek")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of Parameter structures that specify input parameters for the stack.
     */
    @JvmName("myjmthnoummxemhp")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The version of the application to deploy. If not supplied, deploys the latest version.
     */
    @JvmName("gqegmolyreffoxmy")
    public suspend fun semanticVersion(`value`: Output<String>) {
        this.semanticVersion = value
    }

    /**
     * @param value A list of tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hlfyqiocdkbgmihu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the application from the Serverless Application Repository.
     */
    @JvmName("tqkvddthnuxdyvtl")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("vjcsfnywebxwvkvv")
    public suspend fun capabilities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param values A list of capabilities. Valid values are `CAPABILITY_IAM`, `CAPABILITY_NAMED_IAM`, `CAPABILITY_RESOURCE_POLICY`, or `CAPABILITY_AUTO_EXPAND`
     */
    @JvmName("kuwcqipwmmhbfvbx")
    public suspend fun capabilities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value The name of the stack to create. The resource deployed in AWS will be prefixed with `serverlessrepo-`
     */
    @JvmName("yrsstpveskxnpemx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of Parameter structures that specify input parameters for the stack.
     */
    @JvmName("gpgmtggifcbnqlff")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values A map of Parameter structures that specify input parameters for the stack.
     */
    @JvmName("hdnqdbgwxtwompvs")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The version of the application to deploy. If not supplied, deploys the latest version.
     */
    @JvmName("syrnlbkhilovosrm")
    public suspend fun semanticVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.semanticVersion = mapped
    }

    /**
     * @param value A list of tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sbrnqtmtntcaehos")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of tags to associate with this stack. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pghnutgcugqvkrww")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CloudFormationStackArgs = CloudFormationStackArgs(
        applicationId = applicationId,
        capabilities = capabilities,
        name = name,
        parameters = parameters,
        semanticVersion = semanticVersion,
        tags = tags,
    )
}
