@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.serverlessrepository.kotlin

import com.pulumi.aws.serverlessrepository.ServerlessrepositoryFunctions.getApplicationPlain
import com.pulumi.aws.serverlessrepository.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.aws.serverlessrepository.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.aws.serverlessrepository.kotlin.outputs.GetApplicationResult
import com.pulumi.aws.serverlessrepository.kotlin.outputs.GetApplicationResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ServerlessrepositoryFunctions {
    /**
     * Use this data source to get information about an AWS Serverless Application Repository application. For example, this can be used to determine the required `capabilities` for an application.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.serverlessrepository.ServerlessrepositoryFunctions;
     * import com.pulumi.aws.serverlessrepository.inputs.GetApplicationArgs;
     * import com.pulumi.aws.serverlessrepository.CloudFormationStack;
     * import com.pulumi.aws.serverlessrepository.CloudFormationStackArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleApplication = ServerlessrepositoryFunctions.getApplication(GetApplicationArgs.builder()
     *             .applicationId("arn:aws:serverlessrepo:us-east-1:123456789012:applications/ExampleApplication")
     *             .build());
     *         var exampleCloudFormationStack = new CloudFormationStack("exampleCloudFormationStack", CloudFormationStackArgs.builder()
     *             .applicationId(exampleApplication.applyValue(getApplicationResult -> getApplicationResult.applicationId()))
     *             .semanticVersion(exampleApplication.applyValue(getApplicationResult -> getApplicationResult.semanticVersion()))
     *             .capabilities(exampleApplication.applyValue(getApplicationResult -> getApplicationResult.requiredCapabilities()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getApplication.
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        toKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param applicationId ARN of the application.
     * @param semanticVersion Requested version of the application. By default, retrieves the latest version.
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(applicationId: String, semanticVersion: String? = null):
        GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            applicationId = applicationId,
            semanticVersion = semanticVersion,
        )
        return toKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;serverlessrepository&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit):
        GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }
}
