@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.serverlessrepository.kotlin.inputs

import com.pulumi.aws.serverlessrepository.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplication.
 * @property applicationId ARN of the application.
 * @property semanticVersion Requested version of the application. By default, retrieves the latest version.
 */
public data class GetApplicationPlainArgs(
    public val applicationId: String,
    public val semanticVersion: String? = null,
) : ConvertibleToJava<com.pulumi.aws.serverlessrepository.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.aws.serverlessrepository.inputs.GetApplicationPlainArgs =
        com.pulumi.aws.serverlessrepository.inputs.GetApplicationPlainArgs.builder()
            .applicationId(applicationId.let({ args0 -> args0 }))
            .semanticVersion(semanticVersion?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var applicationId: String? = null

    private var semanticVersion: String? = null

    /**
     * @param value ARN of the application.
     */
    @JvmName("jfjduwvmblxtkpae")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationId = mapped
    }

    /**
     * @param value Requested version of the application. By default, retrieves the latest version.
     */
    @JvmName("jtvmigxjyulndrfw")
    public suspend fun semanticVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.semanticVersion = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
        semanticVersion = semanticVersion,
    )
}
