@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.serverlessrepository.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getApplication.
 * @property applicationId ARN of the application.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the application.
 * @property requiredCapabilities A list of capabilities describing the permissions needed to deploy the application.
 * @property semanticVersion
 * @property sourceCodeUrl URL pointing to the source code of the application version.
 * @property templateUrl URL pointing to the Cloud Formation template for the application version.
 */
public data class GetApplicationResult(
    public val applicationId: String,
    public val id: String,
    public val name: String,
    public val requiredCapabilities: List<String>,
    public val semanticVersion: String,
    public val sourceCodeUrl: String,
    public val templateUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.serverlessrepository.outputs.GetApplicationResult):
            GetApplicationResult = GetApplicationResult(
            applicationId = javaType.applicationId(),
            id = javaType.id(),
            name = javaType.name(),
            requiredCapabilities = javaType.requiredCapabilities().map({ args0 -> args0 }),
            semanticVersion = javaType.semanticVersion(),
            sourceCodeUrl = javaType.sourceCodeUrl(),
            templateUrl = javaType.templateUrl(),
        )
    }
}
