@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BudgetResourceAssociation].
 */
@PulumiTagMarker
public class BudgetResourceAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BudgetResourceAssociationArgs = BudgetResourceAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BudgetResourceAssociationArgsBuilder.() -> Unit) {
        val builder = BudgetResourceAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BudgetResourceAssociation {
        val builtJavaResource =
            com.pulumi.aws.servicecatalog.BudgetResourceAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BudgetResourceAssociation(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Budget Resource Association.
 * > **Tip:** A "resource" is either a Service Catalog portfolio or product.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.BudgetResourceAssociation;
 * import com.pulumi.aws.servicecatalog.BudgetResourceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BudgetResourceAssociation("example", BudgetResourceAssociationArgs.builder()
 *             .budgetName("budget-pjtvyakdlyo3m")
 *             .resourceId("prod-dnigbtea24ste")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_budget_resource_association` using the budget name and resource ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/budgetResourceAssociation:BudgetResourceAssociation example budget-pjtvyakdlyo3m:prod-dnigbtea24ste
 * ```
 *
 */
public class BudgetResourceAssociation internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.BudgetResourceAssociation,
) : KotlinCustomResource(javaResource, BudgetResourceAssociationMapper) {
    /**
     * Budget name.
     */
    public val budgetName: Output<String>
        get() = javaResource.budgetName().applyValue({ args0 -> args0 })

    /**
     * Resource identifier.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })
}

public object BudgetResourceAssociationMapper : ResourceMapper<BudgetResourceAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.BudgetResourceAssociation::class == javaResource::class

    override fun map(javaResource: Resource): BudgetResourceAssociation =
        BudgetResourceAssociation(
            javaResource as
                com.pulumi.aws.servicecatalog.BudgetResourceAssociation,
        )
}

/**
 * @see [BudgetResourceAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BudgetResourceAssociation].
 */
public suspend fun budgetResourceAssociation(
    name: String,
    block: suspend BudgetResourceAssociationResourceBuilder.() -> Unit,
): BudgetResourceAssociation {
    val builder = BudgetResourceAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BudgetResourceAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun budgetResourceAssociation(name: String): BudgetResourceAssociation {
    val builder = BudgetResourceAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
