@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.BudgetResourceAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Budget Resource Association.
 * > **Tip:** A "resource" is either a Service Catalog portfolio or product.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.BudgetResourceAssociation;
 * import com.pulumi.aws.servicecatalog.BudgetResourceAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BudgetResourceAssociation("example", BudgetResourceAssociationArgs.builder()
 *             .budgetName("budget-pjtvyakdlyo3m")
 *             .resourceId("prod-dnigbtea24ste")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_budget_resource_association` using the budget name and resource ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/budgetResourceAssociation:BudgetResourceAssociation example budget-pjtvyakdlyo3m:prod-dnigbtea24ste
 * ```
 * @property budgetName Budget name.
 * @property resourceId Resource identifier.
 */
public data class BudgetResourceAssociationArgs(
    public val budgetName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.BudgetResourceAssociationArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.BudgetResourceAssociationArgs =
        com.pulumi.aws.servicecatalog.BudgetResourceAssociationArgs.builder()
            .budgetName(budgetName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetResourceAssociationArgs].
 */
@PulumiTagMarker
public class BudgetResourceAssociationArgsBuilder internal constructor() {
    private var budgetName: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Budget name.
     */
    @JvmName("dxkwwcnsisfademm")
    public suspend fun budgetName(`value`: Output<String>) {
        this.budgetName = value
    }

    /**
     * @param value Resource identifier.
     */
    @JvmName("nqiqoeblscwaweuy")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Budget name.
     */
    @JvmName("nqwrspdxvojstupq")
    public suspend fun budgetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.budgetName = mapped
    }

    /**
     * @param value Resource identifier.
     */
    @JvmName("kttbgjuwlrdovhso")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): BudgetResourceAssociationArgs = BudgetResourceAssociationArgs(
        budgetName = budgetName,
        resourceId = resourceId,
    )
}
