@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Constraint].
 */
@PulumiTagMarker
public class ConstraintResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConstraintArgs = ConstraintArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConstraintArgsBuilder.() -> Unit) {
        val builder = ConstraintArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Constraint {
        val builtJavaResource = com.pulumi.aws.servicecatalog.Constraint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Constraint(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Constraint.
 * > **NOTE:** This resource does not associate a Service Catalog product and portfolio. However, the product and portfolio must be associated (see the `aws.servicecatalog.ProductPortfolioAssociation` resource) prior to creating a constraint or you will receive an error.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.Constraint;
 * import com.pulumi.aws.servicecatalog.ConstraintArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Constraint("example", ConstraintArgs.builder()
 *             .description("Back off, man. I'm a scientist.")
 *             .portfolioId(aws_servicecatalog_portfolio.example().id())
 *             .productId(aws_servicecatalog_product.example().id())
 *             .type("LAUNCH")
 *             .parameters(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("RoleArn", "arn:aws:iam::123456789012:role/LaunchRole")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_constraint` using the constraint ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/constraint:Constraint example cons-nmdkb6cgxfcrs
 * ```
 *
 */
public class Constraint internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.Constraint,
) : KotlinCustomResource(javaResource, ConstraintMapper) {
    /**
     * Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    public val acceptLanguage: Output<String>?
        get() = javaResource.acceptLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the constraint.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Owner of the constraint.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * Constraint parameters in JSON format. The syntax depends on the constraint type. See details below.
     */
    public val parameters: Output<String>
        get() = javaResource.parameters().applyValue({ args0 -> args0 })

    /**
     * Portfolio identifier.
     */
    public val portfolioId: Output<String>
        get() = javaResource.portfolioId().applyValue({ args0 -> args0 })

    /**
     * Product identifier.
     */
    public val productId: Output<String>
        get() = javaResource.productId().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `RESOURCE_UPDATE`, `STACKSET`, and `TEMPLATE`.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConstraintMapper : ResourceMapper<Constraint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.Constraint::class == javaResource::class

    override fun map(javaResource: Resource): Constraint = Constraint(
        javaResource as
            com.pulumi.aws.servicecatalog.Constraint,
    )
}

/**
 * @see [Constraint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Constraint].
 */
public suspend fun constraint(name: String, block: suspend ConstraintResourceBuilder.() -> Unit):
    Constraint {
    val builder = ConstraintResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Constraint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun constraint(name: String): Constraint {
    val builder = ConstraintResourceBuilder()
    builder.name(name)
    return builder.build()
}
