@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.ConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Constraint.
 * > **NOTE:** This resource does not associate a Service Catalog product and portfolio. However, the product and portfolio must be associated (see the `aws.servicecatalog.ProductPortfolioAssociation` resource) prior to creating a constraint or you will receive an error.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.Constraint;
 * import com.pulumi.aws.servicecatalog.ConstraintArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Constraint("example", ConstraintArgs.builder()
 *             .description("Back off, man. I'm a scientist.")
 *             .portfolioId(aws_servicecatalog_portfolio.example().id())
 *             .productId(aws_servicecatalog_product.example().id())
 *             .type("LAUNCH")
 *             .parameters(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("RoleArn", "arn:aws:iam::123456789012:role/LaunchRole")
 *                 )))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_constraint` using the constraint ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/constraint:Constraint example cons-nmdkb6cgxfcrs
 * ```
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property description Description of the constraint.
 * @property parameters Constraint parameters in JSON format. The syntax depends on the constraint type. See details below.
 * @property portfolioId Portfolio identifier.
 * @property productId Product identifier.
 * @property type Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `RESOURCE_UPDATE`, `STACKSET`, and `TEMPLATE`.
 * The following arguments are optional:
 */
public data class ConstraintArgs(
    public val acceptLanguage: Output<String>? = null,
    public val description: Output<String>? = null,
    public val parameters: Output<String>? = null,
    public val portfolioId: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.ConstraintArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.ConstraintArgs =
        com.pulumi.aws.servicecatalog.ConstraintArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .portfolioId(portfolioId?.applyValue({ args0 -> args0 }))
            .productId(productId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConstraintArgs].
 */
@PulumiTagMarker
public class ConstraintArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var description: Output<String>? = null

    private var parameters: Output<String>? = null

    private var portfolioId: Output<String>? = null

    private var productId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("ufcpsniywsabqysv")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Description of the constraint.
     */
    @JvmName("aodgtqgnoihjyweh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Constraint parameters in JSON format. The syntax depends on the constraint type. See details below.
     */
    @JvmName("dsbglafecvtsuqtb")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("duejjmsuwkiavucr")
    public suspend fun portfolioId(`value`: Output<String>) {
        this.portfolioId = value
    }

    /**
     * @param value Product identifier.
     */
    @JvmName("qcwhuyovherjxpwj")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `RESOURCE_UPDATE`, `STACKSET`, and `TEMPLATE`.
     * The following arguments are optional:
     */
    @JvmName("rglcjmluvyuywtaa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("nthxjqhomthfgexo")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Description of the constraint.
     */
    @JvmName("ahnarargwbadpjap")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Constraint parameters in JSON format. The syntax depends on the constraint type. See details below.
     */
    @JvmName("ilxclxuhekdnnbuh")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("imfriywhlrdcmhxy")
    public suspend fun portfolioId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portfolioId = mapped
    }

    /**
     * @param value Product identifier.
     */
    @JvmName("feroaalyreqiqtop")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `RESOURCE_UPDATE`, `STACKSET`, and `TEMPLATE`.
     * The following arguments are optional:
     */
    @JvmName("dkuqgomykifpdxql")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConstraintArgs = ConstraintArgs(
        acceptLanguage = acceptLanguage,
        description = description,
        parameters = parameters,
        portfolioId = portfolioId,
        productId = productId,
        type = type,
    )
}
