@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PortfolioShare].
 */
@PulumiTagMarker
public class PortfolioShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PortfolioShareArgs = PortfolioShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PortfolioShareArgsBuilder.() -> Unit) {
        val builder = PortfolioShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PortfolioShare {
        val builtJavaResource = com.pulumi.aws.servicecatalog.PortfolioShare(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PortfolioShare(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Portfolio Share. Shares the specified portfolio with the specified account or organization node. You can share portfolios to an organization, an organizational unit, or a specific account.
 * If the portfolio share with the specified account or organization node already exists, using this resource to re-create the share will have no effect and will not return an error. You can then use this resource to update the share.
 * > **NOTE:** Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. If a delegated admin is de-registered, they can no longer create portfolio shares.
 * > **NOTE:** AWSOrganizationsAccess must be enabled in order to create a portfolio share to an organization node.
 * > **NOTE:** You can't share a shared resource, including portfolios that contain a shared product.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.PortfolioShare;
 * import com.pulumi.aws.servicecatalog.PortfolioShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PortfolioShare("example", PortfolioShareArgs.builder()
 *             .principalId("012128675309")
 *             .portfolioId(aws_servicecatalog_portfolio.example().id())
 *             .type("ACCOUNT")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_portfolio_share` using the portfolio share ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/portfolioShare:PortfolioShare example port-12344321:ACCOUNT:123456789012
 * ```
 *
 */
public class PortfolioShare internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.PortfolioShare,
) : KotlinCustomResource(javaResource, PortfolioShareMapper) {
    /**
     * Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    public val acceptLanguage: Output<String>?
        get() = javaResource.acceptLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the shared portfolio is imported by the recipient account. If the recipient is organizational, the share is automatically imported, and the field is always set to true.
     */
    public val accepted: Output<Boolean>
        get() = javaResource.accepted().applyValue({ args0 -> args0 })

    /**
     * Portfolio identifier.
     */
    public val portfolioId: Output<String>
        get() = javaResource.portfolioId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
     */
    public val sharePrincipals: Output<Boolean>?
        get() = javaResource.sharePrincipals().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable sharing of `aws.servicecatalog.TagOption` resources when creating the portfolio share.
     */
    public val shareTagOptions: Output<Boolean>?
        get() = javaResource.shareTagOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
     */
    public val waitForAcceptance: Output<Boolean>?
        get() = javaResource.waitForAcceptance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object PortfolioShareMapper : ResourceMapper<PortfolioShare> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.PortfolioShare::class == javaResource::class

    override fun map(javaResource: Resource): PortfolioShare = PortfolioShare(
        javaResource as
            com.pulumi.aws.servicecatalog.PortfolioShare,
    )
}

/**
 * @see [PortfolioShare].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PortfolioShare].
 */
public suspend fun portfolioShare(
    name: String,
    block: suspend PortfolioShareResourceBuilder.() -> Unit,
): PortfolioShare {
    val builder = PortfolioShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PortfolioShare].
 * @param name The _unique_ name of the resulting resource.
 */
public fun portfolioShare(name: String): PortfolioShare {
    val builder = PortfolioShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
